/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.launcher.config;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.launcher.config.ConfigurationException;

public class ConfigurationLoader {
    private static final Logger log = LogManager.getLogger(ConfigurationLoader.class);
    protected static final Pattern ENV_VALUE_PATTERN = Pattern.compile("\\$\\{env(?<boolean>\\?\\?)?:(?<envparam>\\w*)(:?(?<defaultvalue>.*?)?)?\\}");
    protected final Map<String, String> environment;
    protected final Map<String, String> parametersMigration;
    protected final boolean hideDeprecationWarnings;

    public ConfigurationLoader(Map<String, String> environment, Map<String, String> parametersMigration, boolean hideDeprecationWarnings) {
        this.environment = environment;
        this.parametersMigration = parametersMigration;
        this.hideDeprecationWarnings = hideDeprecationWarnings;
    }

    public Properties loadNuxeoDefaults(Path directory) throws ConfigurationException {
        Properties properties = this.loadProperties(directory.resolve("nuxeo.defaults"));
        Path nuxeoDefaultsEnv = directory.resolve(this.getNuxeoEnvironmentConfName());
        if (Files.exists(nuxeoDefaultsEnv, new LinkOption[0])) {
            this.loadProperties(properties, nuxeoDefaultsEnv);
        }
        return properties;
    }

    public Properties loadProperties(Path propsFile) throws ConfigurationException {
        return this.loadProperties(new Properties(), propsFile);
    }

    protected Properties loadProperties(Properties properties, Path propertiesFile) throws ConfigurationException {
        Charset charset = this.checkFileCharset(propertiesFile);
        log.debug("Opening: {} with: {}", (Object)propertiesFile, (Object)charset);
        try (BufferedReader reader = Files.newBufferedReader(propertiesFile, charset);){
            Properties p = new Properties();
            p.load(reader);
            p.stringPropertyNames().forEach(k -> {
                String value = p.getProperty((String)k).trim();
                value = this.replaceEnvironmentVariables(value);
                value = this.replaceBackslashes(value);
                properties.put(k, value);
                if (this.parametersMigration.containsKey(k)) {
                    String newKey = this.parametersMigration.get(k);
                    log.warn("Parameter: {} present in: {} is deprecated - please use: {} instead", k, (Object)propertiesFile, (Object)newKey);
                    properties.put(newKey, value);
                }
            });
        }
        catch (IOException e) {
            throw new ConfigurationException("Unable to read: " + propertiesFile, e);
        }
        return properties;
    }

    protected Charset checkFileCharset(Path propertiesFile) throws ConfigurationException {
        List<Charset> charsetsToBeTested = List.of(StandardCharsets.US_ASCII, StandardCharsets.UTF_8, StandardCharsets.ISO_8859_1);
        for (Charset charsetTest : charsetsToBeTested) {
            Charset charset;
            block11: {
                BufferedReader buffer = Files.newBufferedReader(propertiesFile, charsetTest);
                try {
                    while (buffer.read() != -1) {
                    }
                    charset = charsetTest;
                    if (buffer == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (buffer != null) {
                            try {
                                buffer.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (CharacterCodingException e) {
                        log.trace("Unable to read: {} with charset: {}", (Object)propertiesFile, (Object)charsetTest);
                        continue;
                    }
                    catch (IOException e) {
                        throw new ConfigurationException("Unable to read: " + propertiesFile, e);
                    }
                }
                buffer.close();
            }
            return charset;
        }
        throw new ConfigurationException("Can't identify file charset for " + propertiesFile);
    }

    protected String getNuxeoEnvironmentConfName() {
        return String.format("nuxeo.%s", this.environment.get("NUXEO_ENVIRONMENT"));
    }

    public String replaceEnvironmentVariables(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return value;
        }
        Matcher matcher = ENV_VALUE_PATTERN.matcher(value);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            boolean booleanValue = "??".equals(matcher.group("boolean"));
            String envVarName = matcher.group("envparam");
            String defaultValue = matcher.group("defaultvalue");
            String envValue = this.environment.get(envVarName);
            String result = booleanValue ? (StringUtils.isBlank((CharSequence)envValue) ? "false" : "true") : (StringUtils.isBlank((CharSequence)envValue) ? defaultValue : envValue);
            matcher.appendReplacement(sb, result);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    protected String replaceBackslashes(String value) {
        if (SystemUtils.IS_OS_WINDOWS && value.matches(".*:\\\\.*")) {
            value = value.replaceAll("\\\\", "/");
        }
        return value;
    }
}

