/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.event.impl;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.common.xmap.Context;
import org.nuxeo.common.xmap.XAnnotatedObject;
import org.nuxeo.common.xmap.registry.MapRegistry;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.PostCommitEventListener;
import org.nuxeo.ecm.core.event.impl.EventListenerDescriptor;
import org.nuxeo.ecm.core.event.impl.EventListenerDescriptorComparator;
import org.nuxeo.runtime.RuntimeMessage;
import org.nuxeo.runtime.api.Framework;
import org.w3c.dom.Element;

public class EventListenerList
extends MapRegistry {
    private static final Logger log = LogManager.getLogger(EventListenerList.class);
    protected final List<EventListenerDescriptor> programmaticDescriptors = new CopyOnWriteArrayList<EventListenerDescriptor>();
    protected final List<EventListenerDescriptor> inlineListenersDescriptors = new CopyOnWriteArrayList<EventListenerDescriptor>();
    protected final List<EventListenerDescriptor> syncPostCommitListenersDescriptors = new CopyOnWriteArrayList<EventListenerDescriptor>();
    protected final List<EventListenerDescriptor> asyncPostCommitListenersDescriptors = new CopyOnWriteArrayList<EventListenerDescriptor>();

    public void initialize() {
        super.initialize();
        this.initCache();
    }

    protected String computeId(Context ctx, XAnnotatedObject xObject, Element element) {
        String id = ((EventListenerDescriptor)xObject.newInstance(ctx, element)).getName();
        if (id == null) {
            id = "null";
        }
        return id;
    }

    protected <T> T doRegister(Context ctx, XAnnotatedObject xObject, Element element, String extensionId) {
        EventListenerDescriptor desc = (EventListenerDescriptor)super.doRegister(ctx, xObject, element, extensionId);
        if (desc != null) {
            try {
                desc.initListener(ctx);
            }
            catch (RuntimeException e) {
                String msg = String.format("Failed to register event listener in component '%s': error initializing event listener '%s' (%s)", extensionId, desc.getName(), e.toString());
                Framework.getRuntime().getMessageHandler().addMessage(new RuntimeMessage(RuntimeMessage.Level.ERROR, msg, RuntimeMessage.Source.EXTENSION, extensionId));
            }
        }
        return (T)desc;
    }

    public void setListenerEnabledFlag(String listenerName, boolean enabled) {
        EventListenerDescriptor desc = (EventListenerDescriptor)this.contributions.get(listenerName);
        if (desc == null) {
            return;
        }
        if (enabled) {
            if (this.disabled.remove(listenerName)) {
                log.debug("Enabled listener {}", (Object)listenerName);
            }
        } else if (!this.disabled.contains(listenerName)) {
            this.disabled.add(listenerName);
            log.debug("Disabled listener {}", (Object)listenerName);
        }
        this.initCache();
    }

    public void add(EventListenerDescriptor descriptor) {
        this.programmaticDescriptors.add(descriptor);
        this.updateOnAdd(descriptor);
    }

    public void removeDescriptor(EventListenerDescriptor descriptor) {
        this.programmaticDescriptors.remove(descriptor);
        this.updateOnRemove(descriptor);
    }

    protected void initCache() {
        this.inlineListenersDescriptors.clear();
        this.syncPostCommitListenersDescriptors.clear();
        this.asyncPostCommitListenersDescriptors.clear();
        this.getContributionValues().forEach(this::updateOnAdd);
        this.programmaticDescriptors.forEach(this::updateOnAdd);
    }

    protected void updateOnAdd(EventListenerDescriptor descriptor) {
        if (descriptor == null || !descriptor.isEnabled()) {
            return;
        }
        if (descriptor.isPostCommit) {
            if (descriptor.getIsAsync()) {
                this.asyncPostCommitListenersDescriptors.add(descriptor);
                Collections.sort(this.asyncPostCommitListenersDescriptors, new EventListenerDescriptorComparator());
            } else {
                this.syncPostCommitListenersDescriptors.add(descriptor);
                Collections.sort(this.syncPostCommitListenersDescriptors, new EventListenerDescriptorComparator());
            }
        } else {
            this.inlineListenersDescriptors.add(descriptor);
            Collections.sort(this.inlineListenersDescriptors, new EventListenerDescriptorComparator());
        }
    }

    protected void updateOnRemove(EventListenerDescriptor descriptor) {
        if (descriptor == null) {
            return;
        }
        if (descriptor.isPostCommit) {
            if (descriptor.getIsAsync()) {
                this.asyncPostCommitListenersDescriptors.remove(descriptor);
            } else {
                this.syncPostCommitListenersDescriptors.remove(descriptor);
            }
        } else {
            this.inlineListenersDescriptors.remove(descriptor);
        }
    }

    public List<EventListener> getInLineListeners() {
        return this.getInlineListenersDescriptors().stream().map(EventListenerDescriptor::asEventListener).collect(Collectors.toList());
    }

    public List<PostCommitEventListener> getSyncPostCommitListeners() {
        return this.getSyncPostCommitListenersDescriptors().stream().map(EventListenerDescriptor::asPostCommitListener).collect(Collectors.toList());
    }

    public List<PostCommitEventListener> getAsyncPostCommitListeners() {
        return this.getAsyncPostCommitListenersDescriptors().stream().map(EventListenerDescriptor::asPostCommitListener).collect(Collectors.toList());
    }

    public List<EventListenerDescriptor> getInlineListenersDescriptors() {
        this.checkInitialized();
        return Collections.unmodifiableList(this.inlineListenersDescriptors);
    }

    public List<EventListenerDescriptor> getSyncPostCommitListenersDescriptors() {
        this.checkInitialized();
        return Collections.unmodifiableList(this.syncPostCommitListenersDescriptors);
    }

    public List<EventListenerDescriptor> getAsyncPostCommitListenersDescriptors() {
        this.checkInitialized();
        return Collections.unmodifiableList(this.asyncPostCommitListenersDescriptors);
    }
}

