/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.failover;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.concurrent.locks.ReentrantLock;
import org.mariadb.jdbc.HostAddress;
import org.mariadb.jdbc.MariaDbConnection;
import org.mariadb.jdbc.MariaDbStatement;
import org.mariadb.jdbc.internal.failover.HandleErrorResult;
import org.mariadb.jdbc.internal.failover.Listener;
import org.mariadb.jdbc.internal.logging.Logger;
import org.mariadb.jdbc.internal.logging.LoggerFactory;
import org.mariadb.jdbc.internal.protocol.Protocol;
import org.mariadb.jdbc.internal.util.dao.ServerPrepareResult;
import org.mariadb.jdbc.internal.util.exceptions.ExceptionMapper;

public class FailoverProxy
implements InvocationHandler {
    private static final String METHOD_IS_EXPLICIT_CLOSED = "isExplicitClosed";
    private static final String METHOD_GET_OPTIONS = "getOptions";
    private static final String METHOD_GET_URLPARSER = "getUrlParser";
    private static final String METHOD_GET_PROXY = "getProxy";
    private static final String METHOD_EXECUTE_QUERY = "executeQuery";
    private static final String METHOD_SET_READ_ONLY = "setReadonly";
    private static final String METHOD_GET_READ_ONLY = "getReadonly";
    private static final String METHOD_IS_MASTER_CONNECTION = "isMasterConnection";
    private static final String METHOD_VERSION_GREATER_OR_EQUAL = "versionGreaterOrEqual";
    private static final String METHOD_SESSION_STATE_AWARE = "sessionStateAware";
    private static final String METHOD_CLOSED_EXPLICIT = "closeExplicit";
    private static final String METHOD_ABORT = "abort";
    private static final String METHOD_IS_CLOSED = "isClosed";
    private static final String METHOD_EXECUTE_PREPARED_QUERY = "executePreparedQuery";
    private static final String METHOD_COM_MULTI_PREPARE_EXECUTES = "prepareAndExecutesComMulti";
    private static final String METHOD_PROLOG_PROXY = "prologProxy";
    private static final String METHOD_RESET = "reset";
    private static final String METHOD_IS_VALID = "isValid";
    private static final String METHOD_GET_LOCK = "getLock";
    private static final String METHOD_GET_NO_BACKSLASH = "noBackslashEscapes";
    private static final String METHOD_GET_SERVER_THREAD_ID = "getServerThreadId";
    private static final String METHOD_PROLOG = "prolog";
    private static final String METHOD_GET_CATALOG = "getCatalog";
    private static final String METHOD_GET_TIMEOUT = "getTimeout";
    private static final String METHOD_GET_MAJOR_VERSION = "getMajorServerVersion";
    private static final String METHOD_IN_TRANSACTION = "inTransaction";
    private static final Logger logger = LoggerFactory.getLogger(FailoverProxy.class);
    public final ReentrantLock lock;
    private final Listener listener;

    public FailoverProxy(Listener listener, ReentrantLock lock) throws SQLException {
        this.lock = lock;
        this.listener = listener;
        this.listener.setProxy(this);
        this.listener.initializeConnection();
    }

    private static SQLException addHostInformationToException(SQLException exception, Protocol protocol) {
        if (protocol != null) {
            return new SQLException(exception.getMessage() + "\non " + protocol.getHostAddress().toString() + ",master=" + protocol.isMasterConnection(), exception.getSQLState(), exception.getErrorCode(), exception.getCause());
        }
        return exception;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (METHOD_GET_LOCK.equals(methodName)) {
            return this.lock;
        }
        if (METHOD_GET_NO_BACKSLASH.equals(methodName)) {
            return this.listener.noBackslashEscapes();
        }
        if (METHOD_GET_CATALOG.equals(methodName)) {
            return this.listener.getCatalog();
        }
        if (METHOD_GET_TIMEOUT.equals(methodName)) {
            return this.listener.getTimeout();
        }
        if (METHOD_VERSION_GREATER_OR_EQUAL.equals(methodName)) {
            return this.listener.versionGreaterOrEqual((Integer)args[0], (Integer)args[1], (Integer)args[2]);
        }
        if (METHOD_SESSION_STATE_AWARE.equals(methodName)) {
            return this.listener.sessionStateAware();
        }
        if (METHOD_IS_EXPLICIT_CLOSED.equals(methodName)) {
            return this.listener.isExplicitClosed();
        }
        if (METHOD_GET_OPTIONS.equals(methodName)) {
            return this.listener.getUrlParser().getOptions();
        }
        if (METHOD_GET_MAJOR_VERSION.equals(methodName)) {
            return this.listener.getMajorServerVersion();
        }
        if (METHOD_GET_SERVER_THREAD_ID.equals(methodName)) {
            return this.listener.getServerThreadId();
        }
        if (METHOD_GET_URLPARSER.equals(methodName)) {
            return this.listener.getUrlParser();
        }
        if (METHOD_GET_PROXY.equals(methodName)) {
            return this;
        }
        if (METHOD_IS_CLOSED.equals(methodName)) {
            return this.listener.isClosed();
        }
        if (METHOD_IS_VALID.equals(methodName)) {
            return this.listener.isValid((Integer)args[0]);
        }
        if (METHOD_PROLOG.equals(methodName)) {
            this.listener.prolog((Long)args[0], (MariaDbConnection)args[2], (MariaDbStatement)args[3]);
            return null;
        }
        if (METHOD_EXECUTE_QUERY.equals(methodName)) {
            try {
                this.listener.preExecute();
                return this.executeInvocation(method, args, false);
            }
            catch (SQLException e) {
                if (!this.hasToHandleFailover(e)) return this.executeInvocation(method, args, false);
                return this.handleFailOver(e, method, args, this.listener.getCurrentProtocol());
            }
        }
        if (METHOD_SET_READ_ONLY.equals(methodName)) {
            this.listener.switchReadOnlyConnection((Boolean)args[0]);
            return null;
        }
        if (METHOD_GET_READ_ONLY.equals(methodName)) {
            return this.listener.isReadOnly();
        }
        if (METHOD_IN_TRANSACTION.equals(methodName)) {
            return this.listener.inTransaction();
        }
        if (METHOD_IS_MASTER_CONNECTION.equals(methodName)) {
            return this.listener.isMasterConnection();
        }
        if (METHOD_ABORT.equals(methodName)) {
            this.listener.preAbort();
            return null;
        }
        if (METHOD_CLOSED_EXPLICIT.equals(methodName)) {
            this.listener.preClose();
            return null;
        }
        if (METHOD_COM_MULTI_PREPARE_EXECUTES.equals(methodName) || METHOD_EXECUTE_PREPARED_QUERY.equals(methodName)) {
            boolean mustBeOnMaster = (Boolean)args[0];
            ServerPrepareResult serverPrepareResult = (ServerPrepareResult)args[1];
            if (serverPrepareResult == null) return this.executeInvocation(method, args, false);
            if (!mustBeOnMaster && serverPrepareResult.getUnProxiedProtocol().isMasterConnection() && !this.listener.hasHostFail()) {
                try {
                    logger.trace("re-prepare query \"{}\" on slave (was temporary on master since failover)", (Object)serverPrepareResult.getSql());
                    this.listener.rePrepareOnSlave(serverPrepareResult, false);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            try {
                return this.listener.invoke(method, args, serverPrepareResult.getUnProxiedProtocol());
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() == null) throw e;
                if (!(e.getTargetException() instanceof SQLException) || !this.hasToHandleFailover((SQLException)e.getTargetException())) throw e.getTargetException();
                return this.handleFailOver((SQLException)e.getTargetException(), method, args, serverPrepareResult.getUnProxiedProtocol());
            }
        }
        if (METHOD_PROLOG_PROXY.equals(methodName)) {
            try {
                if (args[0] == null) return null;
                return this.listener.invoke(method, args, ((ServerPrepareResult)args[0]).getUnProxiedProtocol());
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() == null) throw e;
                if (!(e.getTargetException() instanceof SQLException) || !this.hasToHandleFailover((SQLException)e.getTargetException())) throw e.getTargetException();
                return this.handleFailOver((SQLException)e.getTargetException(), method, args, ((ServerPrepareResult)args[0]).getUnProxiedProtocol());
            }
        }
        if (!METHOD_RESET.equals(methodName)) return this.executeInvocation(method, args, false);
        this.listener.reset();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeInvocation(Method method, Object[] args, boolean isSecondExecution) throws Throwable {
        try {
            return this.listener.invoke(method, args);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() != null) {
                if (e.getTargetException() instanceof SQLException) {
                    boolean killCmd;
                    SQLException queryException = (SQLException)e.getTargetException();
                    Protocol protocol = this.listener.getCurrentProtocol();
                    boolean bl = killCmd = (queryException = FailoverProxy.addHostInformationToException(queryException, protocol)) != null && queryException.getSQLState() != null && queryException.getSQLState().equals("70100") && 1927 == queryException.getErrorCode();
                    if (killCmd) {
                        this.handleFailOver(queryException, method, args, protocol);
                        return null;
                    }
                    if (this.hasToHandleFailover(queryException)) {
                        return this.handleFailOver(queryException, method, args, protocol);
                    }
                    if (queryException.getErrorCode() == 1290 && !isSecondExecution && protocol != null && protocol.isMasterConnection() && !protocol.checkIfMaster()) {
                        boolean isReconnected;
                        boolean inTransaction = protocol.inTransaction();
                        this.lock.lock();
                        try {
                            protocol.close();
                            isReconnected = this.listener.primaryFail(null, null, (boolean)false).isReconnected;
                        }
                        finally {
                            this.lock.unlock();
                        }
                        if (isReconnected && !inTransaction) {
                            return this.executeInvocation(method, args, true);
                        }
                        return this.handleFailOver(queryException, method, args, this.listener.getCurrentProtocol());
                    }
                }
                throw e.getTargetException();
            }
            throw e;
        }
    }

    private Object handleFailOver(SQLException qe, Method method, Object[] args, Protocol protocol) throws Throwable {
        HostAddress failHostAddress = null;
        boolean failIsMaster = true;
        if (protocol != null) {
            failHostAddress = protocol.getHostAddress();
            failIsMaster = protocol.isMasterConnection();
        }
        HandleErrorResult handleErrorResult = this.listener.handleFailover(qe, method, args, protocol);
        if (handleErrorResult.mustThrowError) {
            this.listener.throwFailoverMessage(failHostAddress, failIsMaster, qe, handleErrorResult.isReconnected);
        }
        return handleErrorResult.resultObject;
    }

    public boolean hasToHandleFailover(SQLException exception) {
        return exception.getSQLState() != null && (exception.getSQLState().startsWith("08") || exception.getSQLState().equals("70100") && 1927 == exception.getErrorCode());
    }

    public void reconnect() throws SQLException {
        try {
            this.listener.reconnect();
        }
        catch (SQLException e) {
            ExceptionMapper.throwException(e, null, null);
        }
    }

    public Listener getListener() {
        return this.listener;
    }
}

