/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.publisher.impl.core;

import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.platform.publisher.api.PublishedDocument;
import org.nuxeo.ecm.platform.publisher.helper.VersioningHelper;

public class SimpleCorePublishedDocument
implements PublishedDocument {
    private static final long serialVersionUID = 1L;
    protected DocumentModel proxy;
    protected String versionLabel;
    protected boolean isPending;

    public SimpleCorePublishedDocument(DocumentModel doc) {
        if (!doc.isProxy()) {
            throw new NuxeoException("DocumentModel is not a proxy");
        }
        this.proxy = doc;
        this.versionLabel = VersioningHelper.getVersionLabelFor(doc);
    }

    @Override
    public DocumentRef getSourceDocumentRef() {
        return new IdRef(this.proxy.getSourceId());
    }

    @Override
    public String getSourceRepositoryName() {
        return this.proxy.getRepositoryName();
    }

    @Override
    public String getSourceVersionLabel() {
        return this.versionLabel;
    }

    public DocumentModel getProxy() {
        return this.proxy;
    }

    @Override
    public String getPath() {
        return this.proxy.getPathAsString();
    }

    @Override
    public String getParentPath() {
        Path path = this.proxy.getPath();
        return path.removeLastSegments(1).toString();
    }

    public void setPending(boolean isPending) {
        this.isPending = isPending;
    }

    @Override
    public boolean isPending() {
        return this.isPending;
    }
}

