/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.server.jaxrs.blob;

import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.DocumentBlobHolder;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.platform.web.common.ServletHelper;
import org.nuxeo.ecm.webengine.forms.FormData;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.exceptions.WebResourceNotFoundException;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;
import org.nuxeo.runtime.api.Framework;

@WebObject(type="blob")
public class BlobObject
extends DefaultObject {
    protected DocumentModel doc;
    protected DocumentBlobHolder blobHolder;
    protected String xpath;

    protected void initialize(Object ... args) {
        super.initialize(args);
        if (args.length != 2) {
            throw new IllegalArgumentException("BlobObject takes 2 parameters");
        }
        Object path = (String)args[0];
        this.doc = (DocumentModel)args[1];
        BlobHolder bh = (BlobHolder)this.doc.getAdapter(BlobHolder.class);
        if (path == null) {
            if (bh == null) {
                throw new WebResourceNotFoundException("No BlobHolder found");
            }
            if (!(bh instanceof DocumentBlobHolder)) {
                throw new WebResourceNotFoundException("Unknown BlobHolder class: " + bh.getClass().getName());
            }
            this.blobHolder = (DocumentBlobHolder)bh;
        } else if (((String)path).startsWith("blobholder:")) {
            int index;
            if (bh == null) {
                throw new WebResourceNotFoundException("No BlobHolder found");
            }
            if (!(bh instanceof DocumentBlobHolder)) {
                throw new WebResourceNotFoundException("Unknown BlobHolder class: " + bh.getClass().getName());
            }
            String suffix = ((String)path).substring("blobholder:".length());
            try {
                index = Integer.parseInt(suffix);
            }
            catch (NumberFormatException e) {
                throw new WebResourceNotFoundException("Invalid xpath: " + (String)path);
            }
            if (!suffix.equals(Integer.toString(index))) {
                throw new WebResourceNotFoundException("Invalid xpath: " + (String)path);
            }
            this.blobHolder = index == 0 ? (DocumentBlobHolder)bh : ((DocumentBlobHolder)bh).asDirectBlobHolder(index);
        } else if (bh instanceof DocumentBlobHolder && ((DocumentBlobHolder)bh).getXpath().equals(path)) {
            this.blobHolder = (DocumentBlobHolder)bh;
        } else {
            if (!((String)path).contains(":")) {
                SchemaManager schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
                int slash = ((String)path).indexOf(47);
                String first = slash == -1 ? path : ((String)path).substring(0, slash);
                for (Schema schema : schemaManager.getSchemas()) {
                    if (schema.getNamespace().hasPrefix() || schema.getField(first) == null) continue;
                    path = schema.getName() + ":" + (String)path;
                    break;
                }
            }
            if (!((String)path).contains(":")) {
                throw new WebResourceNotFoundException("Invalid xpath: " + (String)path);
            }
            this.blobHolder = new DocumentBlobHolder(this.doc, (String)path);
        }
        this.xpath = this.blobHolder.getXpath();
    }

    public <A> A getAdapter(Class<A> adapter) {
        if (Blob.class.isAssignableFrom(adapter)) {
            return adapter.cast(this.blobHolder.getBlob());
        }
        if (BlobHolder.class.isAssignableFrom(adapter)) {
            return adapter.cast(this.blobHolder);
        }
        return (A)super.getAdapter(adapter);
    }

    public DocumentBlobHolder getBlobHolder() {
        return this.blobHolder;
    }

    @GET
    public Object doGet(@Context Request request) {
        Blob blob;
        if (this.blobHolder instanceof DocumentBlobHolder) {
            return this.blobHolder;
        }
        try {
            blob = this.blobHolder.getBlob();
        }
        catch (PropertyNotFoundException e) {
            throw new WebResourceNotFoundException("Invalid xpath");
        }
        return blob;
    }

    @Deprecated
    public static Response buildResponseFromBlob(Request request, HttpServletRequest httpServletRequest, Blob blob, String filename) {
        Response.ResponseBuilder builder;
        String digest;
        EntityTag etag;
        if (filename == null) {
            filename = blob.getFilename();
        }
        EntityTag entityTag = etag = (digest = blob.getDigest()) == null ? null : new EntityTag(digest);
        if (etag != null && (builder = request.evaluatePreconditions(etag)) != null) {
            return builder.build();
        }
        String contentDisposition = ServletHelper.getRFC2231ContentDisposition((HttpServletRequest)httpServletRequest, (String)filename);
        Response.ResponseBuilder builder2 = Response.ok((Object)blob).header("Content-Disposition", (Object)contentDisposition).type(blob.getMimeType());
        if (etag != null) {
            builder2.tag(etag);
        }
        return builder2.build();
    }

    @DELETE
    public Response doDelete() {
        try {
            this.doc.getProperty(this.xpath).remove();
        }
        catch (PropertyNotFoundException e) {
            throw new NuxeoException("Failed to delete attached file into property: " + this.xpath, (Throwable)e, 400);
        }
        CoreSession session = this.ctx.getCoreSession();
        session.saveDocument(this.doc);
        session.save();
        return Response.noContent().build();
    }

    @PUT
    public Response doPut() {
        FormData form = this.ctx.getForm();
        Blob blob = form.getFirstBlob();
        if (blob == null) {
            throw new IllegalArgumentException("Could not find any uploaded file");
        }
        try {
            this.doc.setPropertyValue(this.xpath, (Serializable)blob);
        }
        catch (PropertyNotFoundException e) {
            throw new NuxeoException("Failed to attach file into property: " + this.xpath, (Throwable)e, 400);
        }
        this.doc.putContextData("VersioningOption", (Serializable)form.getVersioningOption());
        CoreSession session = this.ctx.getCoreSession();
        session.saveDocument(this.doc);
        session.save();
        return Response.ok((Object)"blob updated").build();
    }
}

