/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.types;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.io.marshallers.json.enrichers.AbstractJsonEnricher;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.runtime.api.Framework;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class SubtypesJsonEnricher
extends AbstractJsonEnricher<DocumentModel> {
    public static final String NAME = "subtypes";

    public SubtypesJsonEnricher() {
        super(NAME);
    }

    public void write(JsonGenerator jg, DocumentModel enriched) throws IOException {
        SchemaManager schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
        Collection<String> subtypes = this.computeSubtypes(enriched);
        jg.writeFieldName(NAME);
        jg.writeStartArray();
        for (String subtype : subtypes) {
            jg.writeStartObject();
            jg.writeStringField("type", subtype);
            jg.writeArrayFieldStart("facets");
            for (String facet : schemaManager.getDocumentType(subtype).getFacets()) {
                jg.writeString(facet);
            }
            jg.writeEndArray();
            jg.writeEndObject();
        }
        jg.writeEndArray();
    }

    protected Collection<String> computeSubtypes(DocumentModel enriched) {
        Set defaultSubtypes = enriched.getDocumentType().getAllowedSubtypes();
        if (enriched.hasFacet("UITypesLocalConfiguration")) {
            return this.computeLocalConfigurationSubtypes(enriched, defaultSubtypes);
        }
        return defaultSubtypes;
    }

    protected Collection<String> computeLocalConfigurationSubtypes(DocumentModel enriched, Collection<String> defaultSubtypes) {
        Boolean denyAllTypes = (Boolean)enriched.getPropertyValue("uitypesconf:denyAllTypes");
        if (BooleanUtils.isNotTrue((Boolean)denyAllTypes)) {
            String[] allowedTypesProperty = (String[])enriched.getPropertyValue("uitypesconf:allowedTypes");
            String[] deniedTypesProperty = (String[])enriched.getPropertyValue("uitypesconf:deniedTypes");
            List<Object> allowedTypes = allowedTypesProperty == null ? Collections.emptyList() : Arrays.asList(allowedTypesProperty);
            List<Object> deniedTypes = deniedTypesProperty == null ? Collections.emptyList() : Arrays.asList(deniedTypesProperty);
            return defaultSubtypes.stream().filter(s -> !deniedTypes.contains(s)).filter(s -> allowedTypes.contains(s) || allowedTypes.isEmpty()).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }
}

