/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.convert.plugins;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.text.StringEscapeUtils;
import org.nuxeo.common.utils.Path;
import org.nuxeo.common.utils.ZipUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.core.convert.cache.SimpleCachableBlobHolder;
import org.nuxeo.ecm.platform.mimetype.MimetypeDetectionException;
import org.nuxeo.ecm.platform.mimetype.MimetypeNotFoundException;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.runtime.api.Framework;

@Deprecated
public class ZipCachableBlobHolder
extends SimpleCachableBlobHolder {
    private static final Log log = LogFactory.getLog(ZipCachableBlobHolder.class);
    protected Blob zipBlob;
    @Deprecated
    protected MimetypeRegistry mimeTypeService;
    protected String key;

    public ZipCachableBlobHolder() {
    }

    public ZipCachableBlobHolder(Blob zipBlob) {
        this.zipBlob = zipBlob;
    }

    public Blob getBlob(String path) throws IOException, MimetypeNotFoundException, MimetypeDetectionException, ConversionException {
        String filePath = this.key + path;
        File file = new File(filePath);
        Blob blob = Blobs.createBlob((File)file);
        String mimeType = ((MimetypeRegistry)Framework.getService(MimetypeRegistry.class)).getMimetypeFromBlob(blob);
        blob.setMimeType(mimeType);
        blob.setFilename(path);
        return blob;
    }

    public Blob getBlob() {
        return this.zipBlob;
    }

    public List<Blob> getBlobs() {
        if (this.blobs == null) {
            try {
                this.load(this.key);
            }
            catch (IOException e) {
                throw new NuxeoException((Throwable)e);
            }
        }
        return this.blobs;
    }

    public void load(String path) throws IOException {
        this.blobs = new ArrayList();
        File base = new File(path);
        if (base.isDirectory()) {
            this.addDirectoryToList(base, "");
        } else {
            File file = new File(path);
            String mimeType = this.getMimeType(file);
            Blob mainBlob = Blobs.createBlob((File)file, (String)mimeType, null, (String)file.getName());
            this.blobs.add(mainBlob);
        }
        this.orderIndexPageFirst(this.blobs);
    }

    public String persist(String basePath) throws IOException {
        Path path = new Path(basePath);
        path = path.append(this.getHash());
        File dir = new File(path.toString());
        dir.mkdir();
        ZipUtils.unzip((InputStream)this.zipBlob.getStream(), (File)dir);
        this.key = dir.getAbsolutePath();
        this.load(path.toString());
        if (this.blobs != null && !((Blob)this.blobs.get(0)).getFilename().contains("index.html")) {
            log.info((Object)"Any index.html file found, generate a listing as index page.");
            File index = new File(dir, "index.html");
            if (index.createNewFile()) {
                Blob indexBlob = this.createIndexBlob();
                this.blobs.add(0, indexBlob);
                FileUtils.writeByteArrayToFile((File)index, (byte[])indexBlob.getByteArray());
            } else {
                log.info((Object)"Unable to create index.html file");
            }
        }
        return this.key;
    }

    public String getMimeType(File file) throws ConversionException {
        try {
            return ((MimetypeRegistry)Framework.getService(MimetypeRegistry.class)).getMimetypeFromFile(file);
        }
        catch (ConversionException e) {
            throw new ConversionException("Could not get MimeTypeRegistry", (Throwable)e);
        }
        catch (MimetypeDetectionException | MimetypeNotFoundException e) {
            return "application/octet-stream";
        }
    }

    @Deprecated
    public MimetypeRegistry getMimeTypeService() throws ConversionException {
        if (this.mimeTypeService == null) {
            this.mimeTypeService = (MimetypeRegistry)Framework.getService(MimetypeRegistry.class);
        }
        return this.mimeTypeService;
    }

    protected Blob createIndexBlob() {
        StringBuilder page = new StringBuilder("<html><body>");
        page.append("<h1>").append(StringEscapeUtils.escapeEcmaScript((String)StringEscapeUtils.escapeHtml4((String)this.zipBlob.getFilename()))).append("</h1>");
        page.append("<ul>");
        for (Blob blob : this.blobs) {
            String fn = StringEscapeUtils.escapeEcmaScript((String)StringEscapeUtils.escapeHtml4((String)blob.getFilename()));
            page.append("<li><a href=\"").append(fn).append("\">");
            page.append(fn);
            page.append("</a></li>");
        }
        page.append("</ul></body></html>");
        return Blobs.createBlob((String)page.toString(), (String)"text/html");
    }
}

