/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.xmap.registry;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.common.xmap.Context;
import org.nuxeo.common.xmap.XAnnotatedMember;
import org.nuxeo.common.xmap.XAnnotatedObject;
import org.nuxeo.common.xmap.registry.AbstractRegistry;
import org.nuxeo.common.xmap.registry.Registry;
import org.w3c.dom.Element;

public class MapRegistry
extends AbstractRegistry
implements Registry {
    private static final Logger log = LogManager.getLogger(MapRegistry.class);
    protected Map<String, Object> contributions = Collections.synchronizedMap(new LinkedHashMap());
    protected Set<String> disabled = ConcurrentHashMap.newKeySet();

    @Override
    public void initialize() {
        this.contributions.clear();
        this.disabled.clear();
        super.initialize();
    }

    public <T> Map<String, T> getContributions() {
        this.checkInitialized();
        return this.contributions.entrySet().stream().filter(x -> !this.disabled.contains(x.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v2, LinkedHashMap::new));
    }

    public <T> List<T> getContributionValues() {
        this.checkInitialized();
        return this.contributions.entrySet().stream().filter(x -> !this.disabled.contains(x.getKey())).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    public <T> Optional<T> getContribution(String id) {
        this.checkInitialized();
        if (this.disabled.contains(id)) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.contributions.get(id));
    }

    protected String computeId(Context ctx, XAnnotatedObject xObject, Element element) {
        String id = (String)xObject.getRegistryId().getValue(ctx, element);
        if (id == null) {
            id = "null";
        }
        return id;
    }

    @Override
    protected <T> T doRegister(Context ctx, XAnnotatedObject xObject, Element element, String extensionId) {
        Object contrib;
        String id = this.computeId(ctx, xObject, element);
        XAnnotatedMember remove = xObject.getRemove();
        if (remove != null && Boolean.TRUE.equals(remove.getValue(ctx, element))) {
            this.contributions.remove(id);
            return null;
        }
        XAnnotatedMember merge = xObject.getMerge();
        if (merge != null && Boolean.TRUE.equals(merge.getValue(ctx, element))) {
            Object contribution = this.contributions.get(id);
            if (contribution != null && xObject.getCompatWarnOnMerge() && !merge.hasValue(ctx, element)) {
                log.warn("The contribution with id '{}' on extension '{}' has been implicitly merged: the compatibility mechanism on its descriptor class '{}' detected it, and the attribute merge=\"true\" should be added to this definition.", (Object)id, (Object)extensionId, (Object)contribution.getClass().getName());
            }
            contrib = xObject.newInstance(ctx, element, contribution);
        } else {
            contrib = xObject.newInstance(ctx, element);
        }
        this.contributions.put(id, contrib);
        XAnnotatedMember enable = xObject.getEnable();
        if (enable != null && enable.hasValue(ctx, element)) {
            Object enabled = enable.getValue(ctx, element);
            if (enabled != null && Boolean.FALSE.equals(enabled)) {
                this.disabled.add(id);
            } else {
                this.disabled.remove(id);
            }
        }
        return (T)contrib;
    }
}

