/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.mem;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.nuxeo.ecm.core.api.DocumentNotFoundException;
import org.nuxeo.ecm.core.api.Lock;
import org.nuxeo.ecm.core.api.lock.LockManager;
import org.nuxeo.ecm.core.blob.DocumentBlobManager;
import org.nuxeo.ecm.core.storage.State;
import org.nuxeo.ecm.core.storage.dbs.DBSRepositoryBase;
import org.nuxeo.ecm.core.storage.dbs.DBSRepositoryDescriptor;
import org.nuxeo.ecm.core.storage.mem.MemConnection;
import org.nuxeo.ecm.core.storage.mem.MemRepositoryDescriptor;
import org.nuxeo.runtime.api.Framework;

public class MemRepository
extends DBSRepositoryBase {
    protected static final String NOSCROLL_ID = "noscroll";
    private final AtomicLong temporaryIdCounter = new AtomicLong(0L);
    protected Map<String, State> states;
    protected List<List<String>> binaryPaths;

    public MemRepository(MemRepositoryDescriptor descriptor) {
        super(descriptor.name, (DBSRepositoryDescriptor)descriptor);
        this.initRepository();
    }

    public List<DBSRepositoryBase.IdType> getAllowedIdTypes() {
        return Collections.singletonList(DBSRepositoryBase.IdType.varchar);
    }

    public void shutdown() {
        super.shutdown();
        this.states = null;
    }

    protected void initRepository() {
        this.states = new ConcurrentHashMap<String, State>();
        try (MemConnection connection = this.getConnection();){
            connection.initRepository();
        }
    }

    protected String generateNewId() {
        return UUID.randomUUID().toString();
    }

    public boolean supportsTransactions() {
        return false;
    }

    public MemConnection getConnection() {
        return new MemConnection(this);
    }

    public synchronized Lock getLock(String id) {
        State state = this.states.get(id);
        if (state == null) {
            throw new DocumentNotFoundException(id);
        }
        String owner = (String)((Object)state.get((Object)"ecm:lockOwner"));
        if (owner == null) {
            return null;
        }
        Calendar created = (Calendar)state.get((Object)"ecm:lockCreated");
        return new Lock(owner, created);
    }

    public synchronized Lock setLock(String id, Lock lock) {
        State state = this.states.get(id);
        if (state == null) {
            throw new DocumentNotFoundException(id);
        }
        String owner = (String)((Object)state.get((Object)"ecm:lockOwner"));
        if (owner != null) {
            Calendar created = (Calendar)state.get((Object)"ecm:lockCreated");
            return new Lock(owner, created);
        }
        state.put("ecm:lockOwner", (Serializable)((Object)lock.getOwner()));
        state.put("ecm:lockCreated", (Serializable)lock.getCreated());
        return null;
    }

    public synchronized Lock removeLock(String id, String owner) {
        State state = this.states.get(id);
        if (state == null) {
            throw new DocumentNotFoundException(id);
        }
        String oldOwner = (String)((Object)state.get((Object)"ecm:lockOwner"));
        if (oldOwner == null) {
            return null;
        }
        Calendar oldCreated = (Calendar)state.get((Object)"ecm:lockCreated");
        if (!LockManager.canLockBeRemoved((String)oldOwner, (String)owner)) {
            return new Lock(oldOwner, oldCreated, true);
        }
        state.put("ecm:lockOwner", null);
        state.put("ecm:lockCreated", null);
        return new Lock(oldOwner, oldCreated);
    }

    protected void initBlobsPaths() {
        MemBlobFinder finder = new MemBlobFinder();
        finder.visit();
        this.binaryPaths = finder.binaryPaths;
    }

    public void markReferencedBinaries() {
        DocumentBlobManager blobManager = (DocumentBlobManager)Framework.getService(DocumentBlobManager.class);
        for (State state : this.states.values()) {
            for (List<String> path : this.binaryPaths) {
                this.markReferencedBinaries(state, path, 0, blobManager);
            }
        }
    }

    protected void markReferencedBinaries(State state, List<String> path, int start, DocumentBlobManager blobManager) {
        for (int i = start; i < path.size(); ++i) {
            String name = path.get(i);
            Serializable value = state.get((Object)name);
            if (!(value instanceof State)) {
                if (value instanceof List) {
                    List list = (List)((Object)value);
                    for (Object v : list) {
                        if (v instanceof State) {
                            this.markReferencedBinaries((State)v, path, i + 1, blobManager);
                            continue;
                        }
                        this.markReferencedBinary(v, blobManager);
                    }
                }
                state = null;
                break;
            }
            state = (State)value;
        }
        if (state != null) {
            Serializable data = state.get((Object)"data");
            this.markReferencedBinary(data, blobManager);
            if (this.isFulltextStoredInBlob()) {
                data = state.get((Object)"ecm:fulltextBinary");
                this.markReferencedBinary(data, blobManager);
            }
        }
    }

    protected void markReferencedBinary(Object value, DocumentBlobManager blobManager) {
        if (!(value instanceof String)) {
            return;
        }
        String key = (String)value;
        blobManager.markReferencedBinary(key, this.repositoryName);
    }

    protected static class MemBlobFinder
    extends DBSRepositoryBase.BlobFinder {
        protected List<List<String>> binaryPaths = new ArrayList<List<String>>();

        protected MemBlobFinder() {
        }

        protected void recordBlobPath() {
            this.binaryPaths.add(new ArrayList(this.path));
        }
    }
}

