/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.processor.support;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ro.isdc.wro.util.WroUtil;

public class CssImportInspector {
    private static final Pattern PATTERN = Pattern.compile(WroUtil.loadRegexpWithKey("cssImport"));
    private static final String REGEX_IMPORT_FROM_COMMENTS = WroUtil.loadRegexpWithKey("cssImportFromComments");
    private static final int INDEX_URL = 1;
    private final Matcher matcher;

    public CssImportInspector(String cssContent) {
        this.matcher = this.getMatcher(this.removeImportsFromComments(cssContent));
    }

    protected Matcher getMatcher(String cssContent) {
        return PATTERN.matcher(cssContent);
    }

    public final String removeImportStatements() {
        StringBuffer sb = new StringBuffer();
        while (this.matcher.find()) {
            this.matcher.appendReplacement(sb, "");
        }
        this.matcher.appendTail(sb);
        return sb.toString();
    }

    public final boolean containsImport() {
        return this.matcher.find();
    }

    public final List<String> findImports() {
        ArrayList<String> list = new ArrayList<String>();
        while (this.matcher.find()) {
            list.add(this.extractImportUrl(this.matcher));
        }
        return list;
    }

    protected String extractImportUrl(Matcher matcher) {
        return matcher.group(1);
    }

    final String removeImportsFromComments(String content) {
        return content.replaceAll(REGEX_IMPORT_FROM_COMMENTS, "");
    }
}

