/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.support.hash;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.model.resource.support.hash.HashStrategy;

public abstract class AbstractDigesterHashStrategy
implements HashStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDigesterHashStrategy.class);

    @Override
    public String getHash(InputStream input) throws IOException {
        String string;
        block9: {
            if (input == null) {
                throw new IllegalArgumentException("Content cannot be null!");
            }
            InputStream inputStream = input;
            try {
                MessageDigest messageDigest = this.newMessageDigest();
                byte[] digest = messageDigest.digest(IOUtils.toByteArray((InputStream)input));
                String hash = new BigInteger(1, digest).toString(16);
                LOG.debug("{} hash: {}", (Object)this.getClass().getSimpleName(), (Object)hash);
                string = hash;
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoSuchAlgorithmException e) {
                    throw new WroRuntimeException("Exception occured while computing hash", e);
                }
            }
            inputStream.close();
        }
        return string;
    }

    protected abstract MessageDigest newMessageDigest() throws NoSuchAlgorithmException;
}

