/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.htmlsanitizer;

import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;
import org.nuxeo.ecm.platform.htmlsanitizer.FieldDescriptor;
import org.nuxeo.ecm.platform.htmlsanitizer.HtmlSanitizerDescriptor;
import org.nuxeo.ecm.platform.htmlsanitizer.HtmlSanitizerService;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;
import org.owasp.html.HtmlPolicyBuilder;
import org.owasp.html.PolicyFactory;

public class HtmlSanitizerServiceImpl
extends DefaultComponent
implements HtmlSanitizerService {
    private static final Logger log = LogManager.getLogger(HtmlSanitizerServiceImpl.class);
    public static final String ANTISAMY_XP = "antisamy";
    public static final String SANITIZER_XP = "sanitizer";
    protected PolicyFactory policy;
    protected List<HtmlSanitizerDescriptor> sanitizers;

    public void start(ComponentContext context) {
        this.getRegistryContribution(ANTISAMY_XP).ifPresent(desc -> {
            URL url = desc.policy.toURL();
            HtmlPolicyBuilder builder = new HtmlPolicyBuilder();
            try {
                builder.loadAntiSamyPolicy(url);
                this.initializeBuilder(builder);
                this.policy = builder.toFactory();
            }
            catch (IOException e) {
                this.policy = null;
                throw new NuxeoException("Cannot parse AntiSamy policy: " + desc.policy, (Throwable)e);
            }
        });
        this.sanitizers = new ArrayList<HtmlSanitizerDescriptor>(1);
        this.getRegistryContributions(SANITIZER_XP).forEach(desc -> {
            if (desc.fields.isEmpty()) {
                log.error("Sanitizer has no fields: {}", desc);
                return;
            }
            this.sanitizers.add((HtmlSanitizerDescriptor)desc);
        });
    }

    public void stop(ComponentContext context) throws InterruptedException {
        this.policy = null;
        this.sanitizers = null;
    }

    protected void initializeBuilder(HtmlPolicyBuilder builder) {
        builder.allowStandardUrlProtocols();
        builder.allowUrlProtocols(new String[]{"data"});
        builder.allowStyling();
        builder.disallowElements(new String[]{"script"});
    }

    protected List<HtmlSanitizerDescriptor> getSanitizers() {
        return this.sanitizers;
    }

    @Override
    public void sanitizeDocument(DocumentModel doc) {
        if (this.policy == null) {
            log.error("Cannot sanitize, no policy registered");
            return;
        }
        for (HtmlSanitizerDescriptor sanitizer : this.sanitizers) {
            if (!sanitizer.types.isEmpty() && !sanitizer.types.contains(doc.getType())) continue;
            for (FieldDescriptor field : sanitizer.fields) {
                Property prop;
                String fieldName = field.getContentField();
                String filterField = field.getFilterField();
                if (filterField != null) {
                    Property filterProp;
                    try {
                        filterProp = doc.getProperty(filterField);
                    }
                    catch (PropertyNotFoundException e) {
                        continue;
                    }
                    if (field.match(String.valueOf(filterProp.getValue())) != field.doSanitize()) continue;
                }
                try {
                    prop = doc.getProperty(fieldName);
                }
                catch (PropertyNotFoundException e) {
                    continue;
                }
                Serializable value = prop.getValue();
                if (value == null) continue;
                if (!(value instanceof String)) {
                    log.debug("Cannot sanitize non-string field: {}", (Object)field);
                    continue;
                }
                String info = "doc " + doc.getPathAsString() + " (" + doc.getId() + ") field " + field;
                String newValue = this.sanitizeString((String)((Object)value), info);
                if (newValue.equals(value)) continue;
                prop.setValue((Object)newValue);
            }
        }
    }

    @Override
    public String sanitizeString(String string, String info) {
        if (this.policy == null) {
            log.error("Cannot sanitize, no policy registered");
            return string;
        }
        return this.policy.sanitize(string);
    }
}

