/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.lock;

import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.nuxeo.ecm.core.api.lock.LockManager;
import org.nuxeo.runtime.RuntimeMessage;
import org.nuxeo.runtime.RuntimeServiceException;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;

public class LockManagerService
extends DefaultComponent {
    private static final String XP_LOCKMANAGER = "lockmanager";
    protected Map<String, LockManager> lockManagers;

    public int getApplicationStartedOrder() {
        return 99;
    }

    public void start(ComponentContext context) {
        this.lockManagers = new ConcurrentHashMap<String, LockManager>();
        this.getRegistryContributions(XP_LOCKMANAGER).forEach(desc -> {
            if (desc.klass != null) {
                try {
                    Constructor<? extends LockManager> ctor = desc.klass.getConstructor(String.class);
                    this.lockManagers.put(desc.name, ctor.newInstance(this.name));
                }
                catch (ReflectiveOperationException e) {
                    this.addRuntimeMessage(RuntimeMessage.Level.ERROR, e.getMessage());
                    throw new RuntimeServiceException((Throwable)e);
                }
            }
        });
    }

    public void stop(ComponentContext context) throws InterruptedException {
        this.lockManagers = null;
    }

    public LockManager getLockManager(String name) {
        return this.lockManagers.get(name);
    }

    public void registerLockManager(String name, LockManager lockManager) {
        this.lockManagers.put(name, lockManager);
    }

    public void unregisterLockManager(String name) {
        this.lockManagers.remove(name);
    }
}

