/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.mongodb;

import com.mongodb.MongoTimeoutException;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoDatabase;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.nuxeo.launcher.config.ConfigurationException;
import org.nuxeo.launcher.config.ConfigurationHolder;
import org.nuxeo.launcher.config.backingservices.BackingChecker;
import org.nuxeo.runtime.mongodb.MongoDBConnectionConfig;
import org.nuxeo.runtime.mongodb.MongoDBConnectionHelper;

public class MongoDBChecker
implements BackingChecker {
    private static final Logger log = LogManager.getLogger(MongoDBChecker.class);
    public static final String TEMPLATE_NAME = "mongodb";
    public static final String CONFIG_NAME = "mongodb-connection-config.xml";
    public static final String PARAM_MONGODB_CHECK_TIMEOUT = "nuxeo.mongodb.check.timeout";
    public static final int DEFAULT_CHECK_TIMEOUT_IN_SECONDS = 5;

    public boolean accepts(ConfigurationHolder configHolder) {
        return configHolder.getIncludedTemplateNames().contains(TEMPLATE_NAME);
    }

    public void check(ConfigurationHolder configHolder) throws ConfigurationException {
        MongoDBConnectionConfig config = (MongoDBConnectionConfig)this.getDescriptor(configHolder, CONFIG_NAME, MongoDBConnectionConfig.class);
        try (MongoClient mongoClient = MongoDBConnectionHelper.newMongoClient((MongoDBConnectionConfig)config, builder -> builder.applicationName("Nuxeo DB Check").applyToClusterSettings(s -> s.serverSelectionTimeout((long)this.getCheckTimeoutInSeconds(configHolder), TimeUnit.SECONDS)));){
            MongoDatabase database = mongoClient.getDatabase(config.dbname);
            Document ping = new Document("ping", (Object)"1");
            database.runCommand((Bson)ping);
        }
        catch (MongoTimeoutException e) {
            throw new ConfigurationException(String.format("Unable to connect to MongoDB at: %s, please check your connection", config.server), (Throwable)e);
        }
    }

    private int getCheckTimeoutInSeconds(ConfigurationHolder configHolder) {
        try {
            return configHolder.getPropertyAsInteger(PARAM_MONGODB_CHECK_TIMEOUT, 5);
        }
        catch (NumberFormatException e) {
            log.warn("Invalid format for: {} parameter, using default value instead", (Object)PARAM_MONGODB_CHECK_TIMEOUT, (Object)e);
            return 5;
        }
    }
}

