/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.mongodb;

import java.util.function.BiConsumer;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.storage.dbs.DBSRepositoryDescriptor;
import org.nuxeo.ecm.core.storage.dbs.DBSRepositoryService;
import org.nuxeo.ecm.core.storage.mongodb.MongoDBRepositoryDescriptor;
import org.nuxeo.ecm.core.storage.mongodb.MongoDBRepositoryFactory;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.mongodb.MongoDBComponent;
import org.nuxeo.runtime.mongodb.MongoDBConnectionConfig;
import org.nuxeo.runtime.mongodb.MongoDBConnectionService;

public class MongoDBRepositoryService
extends DefaultComponent {
    public static final String DB_DEFAULT = "nuxeo";
    private static final String XP_REPOSITORY = "repository";

    public void registerContribution(Object contrib, String xpoint, ComponentInstance contributor) {
        if (XP_REPOSITORY.equals(xpoint)) {
            MongoDBRepositoryDescriptor desc = (MongoDBRepositoryDescriptor)((Object)contrib);
            ((DBSRepositoryService)Framework.getService(DBSRepositoryService.class)).addContribution((DBSRepositoryDescriptor)desc, MongoDBRepositoryFactory.class);
            this.handleConnectionContribution(desc, (c, d) -> c.registerContribution(d, "connection", contributor));
        }
    }

    public void unregisterContribution(Object contrib, String xpoint, ComponentInstance contributor) {
        if (XP_REPOSITORY.equals(xpoint)) {
            MongoDBRepositoryDescriptor desc = (MongoDBRepositoryDescriptor)((Object)contrib);
            ((DBSRepositoryService)Framework.getService(DBSRepositoryService.class)).removeContribution((DBSRepositoryDescriptor)desc, MongoDBRepositoryFactory.class);
            this.handleConnectionContribution(desc, (c, d) -> c.unregisterContribution(d, "connection", contributor));
        }
    }

    @Deprecated
    protected void handleConnectionContribution(MongoDBRepositoryDescriptor descriptor, BiConsumer<DefaultComponent, MongoDBConnectionConfig> consumer) {
        if (StringUtils.isNotBlank((CharSequence)descriptor.server)) {
            String id = "repository/" + descriptor.name;
            String server = descriptor.server;
            String dbName = (String)StringUtils.defaultIfBlank((CharSequence)descriptor.dbname, (CharSequence)DB_DEFAULT);
            MongoDBConnectionConfig connection = new MongoDBConnectionConfig();
            connection.server = server;
            connection.dbname = dbName;
            connection.id = id;
            MongoDBComponent component = (MongoDBComponent)Framework.getService(MongoDBConnectionService.class);
            consumer.accept((DefaultComponent)component, connection);
        }
    }
}

