/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.action;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.AbstractSession;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentExistsException;
import org.nuxeo.ecm.core.api.DocumentNotFoundException;
import org.nuxeo.ecm.core.bulk.action.computation.AbstractBulkComputation;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.core.model.Session;
import org.nuxeo.lib.stream.computation.Topology;
import org.nuxeo.runtime.stream.StreamProcessorTopology;

public class DeletionAction
implements StreamProcessorTopology {
    private static final Logger log = LogManager.getLogger(DeletionAction.class);
    public static final String ACTION_NAME = "deletion";
    public static final String ACTION_FULL_NAME = "bulk/deletion";

    public Topology getTopology(Map<String, String> options) {
        return Topology.builder().addComputation(DeletionComputation::new, Arrays.asList("i1:bulk/deletion", "o1:bulk/status")).build();
    }

    public static class DeletionComputation
    extends AbstractBulkComputation {
        public DeletionComputation() {
            super(DeletionAction.ACTION_FULL_NAME);
        }

        protected void compute(CoreSession session, List<String> ids, Map<String, Serializable> properties) {
            Session internalSession = ((AbstractSession)session).getSession();
            for (String id : ids) {
                try {
                    Document doc = internalSession.getDocumentByUUID(id);
                    doc.removeSingleton();
                }
                catch (DocumentNotFoundException doc) {
                }
                catch (DocumentExistsException e) {
                    log.debug("Cannot delete {}: {}", (Object)id, (Object)e.getMessage());
                }
            }
        }
    }
}

