/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.metrics.reporter;

import io.dropwizard.metrics5.MetricAttribute;
import io.dropwizard.metrics5.MetricFilter;
import io.dropwizard.metrics5.MetricRegistry;
import io.opencensus.common.Duration;
import io.opencensus.exporter.trace.jaeger.JaegerExporterConfiguration;
import io.opencensus.exporter.trace.jaeger.JaegerTraceExporter;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.common.utils.DurationUtils;
import org.nuxeo.runtime.metrics.AbstractMetricsReporter;

public class JaegerReporter
extends AbstractMetricsReporter {
    private static final Logger log = LogManager.getLogger(JaegerReporter.class);
    protected boolean activated;

    @Override
    public void start(MetricRegistry registry, MetricFilter filter, Set<MetricAttribute> deniedExpansions) {
        log.warn("Creating Jaeger reporter");
        String url = (String)this.options.get("url");
        Duration timeout = Duration.create((long)DurationUtils.parsePositive((String)((String)this.options.get("timeout")), (java.time.Duration)DEFAULT_TIMEOUT).getSeconds(), (int)0);
        String service = this.options.getOrDefault("service", "nuxeo");
        JaegerExporterConfiguration configuration = JaegerExporterConfiguration.builder().setServiceName(service).setThriftEndpoint(url).setDeadline(timeout).build();
        JaegerTraceExporter.createAndRegister((JaegerExporterConfiguration)configuration);
        this.activated = true;
        this.enableTracing();
    }

    @Override
    public void stop() {
        log.debug("Stop reporting");
        if (this.activated) {
            JaegerTraceExporter.unregister();
            this.activated = false;
        }
    }
}

