/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.web.common.requestcontroller.service;

import java.util.regex.Pattern;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.common.xmap.registry.XRegistry;
import org.nuxeo.common.xmap.registry.XRegistryId;

@XObject(value="filterConfig")
@XRegistry(compatWarnOnMerge=true)
public class FilterConfigDescriptor {
    public static final String DEFAULT_CACHE_DURATION = "3599";
    @XNode(value="@name", fallback="pattern")
    @XRegistryId
    protected String name;
    @XNode(value="@synchonize")
    protected boolean useSync;
    @XNode(value="@transactional")
    protected boolean useTx;
    @XNode(value="@buffered")
    protected boolean useTxBuffered = true;
    @XNode(value="@cached")
    protected boolean cached;
    @XNode(value="@cacheTime", defaultAssignment="3599", trim=true)
    protected String cacheTime;
    @XNode(value="@private")
    protected boolean isPrivate;
    @XNode(value="@grant")
    protected boolean grant = true;
    @XNode(value="pattern")
    protected String pattern;
    protected Pattern compiledPattern;

    public String getName() {
        return this.name;
    }

    public boolean useSync() {
        return this.useSync;
    }

    public boolean useTx() {
        return this.useTx;
    }

    public boolean useTxBuffered() {
        return this.useTxBuffered;
    }

    public boolean isGrantRule() {
        return this.grant;
    }

    public boolean isCached() {
        return this.cached;
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    public String getCacheTime() {
        return this.cacheTime;
    }

    public String getPatternStr() {
        return this.pattern;
    }

    public Pattern getCompiledPattern() {
        if (this.compiledPattern == null) {
            this.compiledPattern = Pattern.compile(this.pattern);
        }
        return this.compiledPattern;
    }
}

