/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.actions;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.common.xmap.registry.XEnable;
import org.nuxeo.common.xmap.registry.XMerge;
import org.nuxeo.common.xmap.registry.XRegistry;
import org.nuxeo.common.xmap.registry.XRegistryId;
import org.nuxeo.ecm.platform.actions.ActionPropertyListDescriptor;
import org.w3c.dom.Element;

@XObject(value="action")
@XRegistry(enable=false)
public class ActionDescriptor {
    @XNode(value="@id")
    @XRegistryId
    protected String id = "";
    @XNode(value="@link")
    protected String link;
    @XNode(value="@enable", fallback="@enabled", defaultAssignment="true")
    @XEnable
    protected Boolean enabled;
    @XNode(value="@label")
    protected String label;
    @XNode(value="@icon")
    protected String icon;
    @XNode(value="@confirm")
    protected String confirm;
    @XNode(value="@help")
    protected String help;
    @XNode(value="@immediate")
    protected Boolean immediate;
    @XNode(value="@accessKey")
    protected String accessKey;
    @XNode(value="@type")
    protected String type;
    @XNode(value="@order")
    protected int order = 0;
    @XNodeList(value="category", type=LinkedHashSet.class, componentType=String.class)
    protected Set<String> categories;
    @XNodeList(value="filter-id", type=ArrayList.class, componentType=String.class)
    @XMerge(value="filters@merge")
    protected List<String> filterIds;
    @XNodeList(value="filter@id", type=ArrayList.class, componentType=String.class)
    @XMerge(value="filters@merge")
    protected List<String> filterElementIds;
    @XNodeList(value="filter", type=ArrayList.class, componentType=Element.class)
    @XMerge(value="filters@merge")
    protected List<Element> filterElements;
    protected static final String PROPERTIES_MERGE_FALLBACK = "properties@append";
    @XNodeMap(value="properties/property", key="@name", type=HashMap.class, componentType=String.class)
    @XMerge(value="properties@merge", fallback="properties@append")
    protected Map<String, String> properties;
    @XNodeMap(value="properties/propertyList", key="@name", type=HashMap.class, componentType=ActionPropertyListDescriptor.class)
    @XMerge(value="properties@merge", fallback="properties@append")
    protected Map<String, ActionPropertyListDescriptor> listProperties;
    protected Map<String, Serializable> propertiesCache;

    protected String getStringProperty(String prop, String defaultValue) {
        Serializable obj;
        Map<String, Serializable> props = this.getProperties();
        if (props != null && props.containsKey(prop) && (obj = props.get(prop)) instanceof String) {
            return (String)((Object)obj);
        }
        return defaultValue;
    }

    public String getLabel() {
        if (this.label == null) {
            return this.getStringProperty("label", null);
        }
        return this.label;
    }

    public String getIcon() {
        if (this.icon == null) {
            return this.getStringProperty("icon", null);
        }
        return this.icon;
    }

    public String getLink() {
        if (this.link == null) {
            return this.getStringProperty("link", null);
        }
        return this.link;
    }

    public List<String> getCategories() {
        return new ArrayList<String>(this.categories);
    }

    public String getId() {
        return this.id;
    }

    public int getOrder() {
        return this.order;
    }

    public List<String> getAllFilterIds() {
        HashSet<String> all = new HashSet<String>(this.filterIds);
        all.addAll(this.filterElementIds);
        return new ArrayList<String>(all);
    }

    public List<Element> getFilterElements() {
        return Collections.unmodifiableList(this.filterElements);
    }

    public String getConfirm() {
        if (this.confirm == null) {
            return this.getStringProperty("confirm", "");
        }
        return this.confirm;
    }

    public String getHelp() {
        if (this.help == null) {
            return this.getStringProperty("help", "");
        }
        return this.help;
    }

    public boolean isImmediate() {
        if (this.immediate == null) {
            Map<String, Serializable> props = this.getProperties();
            if (props != null && props.containsKey("immediate")) {
                Serializable obj = props.get("immediate");
                if (obj instanceof String) {
                    return Boolean.parseBoolean((String)((Object)obj));
                }
                if (obj instanceof Boolean) {
                    return (Boolean)obj;
                }
            }
            return false;
        }
        return this.immediate;
    }

    public String getType() {
        return this.type;
    }

    public Map<String, Serializable> getProperties() {
        if (this.propertiesCache == null) {
            this.propertiesCache = new HashMap<String, Serializable>();
            if (this.properties != null) {
                this.propertiesCache.putAll(this.properties);
            }
            for (Map.Entry<String, ActionPropertyListDescriptor> prop : this.listProperties.entrySet()) {
                this.propertiesCache.put(prop.getKey(), (Serializable)prop.getValue().getValues());
            }
        }
        return this.propertiesCache;
    }

    public String getAccessKey() {
        if (this.accessKey == null) {
            return this.getStringProperty("accessKey", null);
        }
        return this.accessKey;
    }
}

