/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.common.xmap.Context;
import org.nuxeo.common.xmap.XAnnotatedObject;
import org.nuxeo.common.xmap.XMap;
import org.nuxeo.common.xmap.registry.MapRegistry;
import org.nuxeo.common.xmap.registry.Registry;
import org.nuxeo.ecm.platform.actions.Action;
import org.nuxeo.ecm.platform.actions.ActionDescriptor;
import org.nuxeo.ecm.platform.actions.ActionService;
import org.nuxeo.ecm.platform.actions.DefaultActionFilter;
import org.nuxeo.ecm.platform.actions.TypeCompatibility;
import org.nuxeo.runtime.api.Framework;
import org.w3c.dom.Element;

public class ActionRegistry
extends MapRegistry {
    private static final Logger log = LogManager.getLogger(ActionRegistry.class);
    private final Map<String, Action> programmaticActions = new ConcurrentHashMap<String, Action>();
    protected Map<String, List<String>> categories = new ConcurrentHashMap<String, List<String>>();
    protected Map<String, String> typeByCategory = new ConcurrentHashMap<String, String>();
    protected static XAnnotatedObject xFilter;

    public synchronized void addAction(Action action) {
        String id = action.getId();
        if (id == null) {
            log.debug("Cannot add action with null id.");
            return;
        }
        if (log.isDebugEnabled()) {
            if (this.programmaticActions.containsKey(id)) {
                log.debug("Overriding action: '{}'", (Object)action);
            } else {
                log.debug("Registering action: '{}'", (Object)action);
            }
        }
        this.applyCompatibility(action);
        this.programmaticActions.put(id, action);
        this.setInitialized(false);
    }

    public synchronized Action removeAction(String id) {
        if (id == null) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug("Unregistering action: '{}'", (Object)id);
        }
        Action action = this.programmaticActions.remove(id);
        this.setInitialized(false);
        return action;
    }

    public void initialize() {
        super.initialize();
        this.initCache();
    }

    protected void initCache() {
        this.categories.clear();
        this.contributions.entrySet().stream().filter(x -> !this.disabled.contains(x.getKey())).map(Map.Entry::getValue).map(ActionDescriptor.class::cast).forEach(a -> a.getCategories().forEach(event -> this.categories.computeIfAbsent((String)event, k -> new ArrayList()).add(a.getId())));
        this.programmaticActions.entrySet().stream().filter(x -> !this.disabled.contains(x.getKey())).map(Map.Entry::getValue).filter(Action::getAvailable).forEach(a -> a.getCategoryList().forEach(event -> this.categories.computeIfAbsent((String)event, k -> new ArrayList()).add(a.getId())));
    }

    public void setTypeCompatibility(List<TypeCompatibility> compats) {
        this.typeByCategory.clear();
        compats.forEach(compat -> compat.getCategories().forEach(cat -> this.typeByCategory.put((String)cat, compat.getType())));
    }

    protected Registry getFilterRegistry() {
        return (Registry)Framework.getRuntime().getComponentManager().getExtensionPointRegistry(ActionService.ID.getName(), "filters").orElseThrow(() -> new IllegalArgumentException(String.format("Unknown registry for extension point '%s--%s'", ActionService.ID, "filters")));
    }

    public void register(Context ctx, XAnnotatedObject xObject, Element element, String tag) {
        List<Element> innerFilters;
        super.register(ctx, xObject, element, tag);
        ActionDescriptor action = (ActionDescriptor)xObject.newInstance(ctx, element);
        if (action != null && !(innerFilters = action.getFilterElements()).isEmpty()) {
            Registry filterRegistry = this.getFilterRegistry();
            for (Element innerFilter : innerFilters) {
                if (!innerFilter.hasAttribute("append") && !innerFilter.hasAttribute("merge")) {
                    innerFilter.setAttribute("merge", "true");
                }
                filterRegistry.register(ctx, xFilter, innerFilter, tag);
            }
        }
    }

    public void unregister(String tag) {
        super.unregister(tag);
        this.getFilterRegistry().unregister(tag);
    }

    public Action getAction(String id) {
        if (id == null) {
            return null;
        }
        if (this.programmaticActions.containsKey(id)) {
            return this.programmaticActions.get(id);
        }
        return this.getContribution(id).map(desc -> {
            Action action = new Action((ActionDescriptor)desc);
            this.applyCompatibility(action);
            return action;
        }).orElse(null);
    }

    public List<Action> getActions(String category) {
        this.checkInitialized();
        if (category == null) {
            return Collections.emptyList();
        }
        List<String> ids = this.categories.get(category);
        if (ids == null) {
            return Collections.emptyList();
        }
        return ids.stream().filter(Objects::nonNull).filter(id -> !this.disabled.contains(id)).map(id -> {
            if (this.contributions.containsKey(id)) {
                ActionDescriptor desc = (ActionDescriptor)this.contributions.get(id);
                Action action = new Action(desc);
                this.applyCompatibility(category, action);
                return action;
            }
            return this.programmaticActions.get(id);
        }).sorted().collect(Collectors.toList());
    }

    protected void applyCompatibility(Action action) {
        if (action != null && action.getType() == null) {
            for (String cat : action.getCategories()) {
                if (this.applyCompatibility(cat, action)) break;
            }
        }
    }

    protected boolean applyCompatibility(String category, Action action) {
        String type;
        if (category != null && action != null && action.getType() == null && (type = this.typeByCategory.get(category)) != null) {
            action.setType(type);
            this.applyCustomCompatibility(type, action);
            return true;
        }
        return false;
    }

    protected boolean applyCustomCompatibility(String compatType, Action action) {
        if ("admin_rest_document_link".equals(compatType) || "home_rest_document_link".equals(compatType)) {
            boolean applied = false;
            String link = action.getLink();
            if (link != null && !link.startsWith("/")) {
                action.setLink("/" + link);
                applied = true;
            }
            if (applied) {
                log.warn("Applied compatibility to action '{}', its configuration should be reviewed: make sure the link references an absolute path", (Object)action.getId());
                return true;
            }
        }
        return false;
    }

    static {
        XMap fxmap = new XMap();
        fxmap.register(DefaultActionFilter.class);
        xFilter = fxmap.getObject(DefaultActionFilter.class);
    }
}

