/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.services.config;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.common.xmap.registry.XRegistry;
import org.nuxeo.common.xmap.registry.XRegistryId;

@XObject(value="property")
@XRegistry(merge=false, enable=false)
public class ConfigurationPropertyDescriptor {
    protected static final Log log = LogFactory.getLog(ConfigurationPropertyDescriptor.class);
    @XNode(value="@name")
    @XRegistryId
    protected String name;
    @XNode(value="@list")
    public boolean list;
    @XNode(value="@override")
    public boolean override;
    @XNode
    protected String value;

    public ConfigurationPropertyDescriptor clone() {
        ConfigurationPropertyDescriptor clone = new ConfigurationPropertyDescriptor();
        clone.name = this.name;
        clone.value = this.value;
        clone.list = this.list;
        clone.override = this.override;
        return clone;
    }

    public String getId() {
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isList() {
        return this.list;
    }

    public boolean isOverride() {
        return this.override;
    }

    public ConfigurationPropertyDescriptor merge(ConfigurationPropertyDescriptor other) {
        if (this.list) {
            ConfigurationPropertyDescriptor merged = new ConfigurationPropertyDescriptor();
            merged.list = this.list;
            merged.name = this.name;
            merged.value = StringUtils.isNotEmpty((CharSequence)this.value) && !other.override ? this.value + "," + other.value : other.value;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Merging property %s with old %s resulting in %s", other, this, merged));
            }
            return merged;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Overriding existing property %s with %s", this, other));
        }
        if (other.list) {
            other.list = false;
            log.warn((Object)String.format("Property %s cannot be marked as list because it is already defined as not list. Overriding existing property.", other.getName()));
        }
        return other;
    }

    public String toString() {
        return String.format("name=%s, value=%s, list=%s, replace=%s", this.name, this.value, this.list, this.override);
    }
}

