/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.trackers.files;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.io.FileCleaningTracker;
import org.apache.commons.io.FileDeleteStrategy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.common.xmap.registry.XRegistry;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.services.event.EventService;
import org.nuxeo.runtime.trackers.concurrent.ThreadEventHandler;
import org.nuxeo.runtime.trackers.concurrent.ThreadEventListener;
import org.nuxeo.runtime.trackers.files.FileEventHandler;
import org.nuxeo.runtime.trackers.files.FileEventListener;

public class FileEventTracker
extends DefaultComponent {
    protected static final Log log = LogFactory.getLog(FileEventTracker.class);
    protected static final String XP = "configs";
    protected static SafeFileDeleteStrategy deleteStrategy = new SafeFileDeleteStrategy();
    protected final GCDelegate gc = new GCDelegate();
    protected final ThreadLocal<ThreadDelegate> threads = new ThreadLocal();
    protected final ThreadEventListener threadsListener = new ThreadEventListener(new ThreadEventHandler(){

        @Override
        public void onEnter(boolean isLongRunning) {
            FileEventTracker.this.setThreadDelegate(isLongRunning);
        }

        @Override
        public void onLeave() {
            FileEventTracker.this.resetThreadDelegate();
        }
    });
    protected final FileEventListener filesListener = new FileEventListener((file, marker) -> this.onContext().onFile(file, marker));

    public static void registerProtectedPath(String path) {
        deleteStrategy.registerProtectedPath(path);
    }

    @Override
    public void activate(ComponentContext context) {
        super.activate(context);
        this.filesListener.install();
        this.setThreadDelegate(false);
    }

    @Override
    public int getApplicationStartedOrder() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void start(ComponentContext context) {
        this.resetThreadDelegate();
        if (this.getRegistryContribution(XP).isPresent()) {
            this.threadsListener.install();
        }
    }

    @Override
    public void deactivate(ComponentContext context) {
        if (Framework.getService(EventService.class) != null) {
            if (this.threadsListener.isInstalled()) {
                this.threadsListener.uninstall();
            }
            this.filesListener.uninstall();
        }
        super.deactivate(context);
    }

    protected FileEventHandler onContext() {
        FileEventHandler actual = this.threads.get();
        if (actual == null) {
            actual = this.gc;
        }
        return actual;
    }

    protected void setThreadDelegate(boolean isLongRunning) {
        if (this.threads.get() != null) {
            throw new IllegalStateException("Thread delegate already installed");
        }
        this.threads.set(new ThreadDelegate(isLongRunning));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetThreadDelegate() throws IllegalStateException {
        ThreadDelegate actual = this.threads.get();
        if (actual == null) {
            return;
        }
        try {
            for (File file : actual.files) {
                if (deleteStrategy.isFileProtected(file)) continue;
                file.delete();
            }
        }
        finally {
            this.threads.remove();
        }
    }

    @XObject(value="enableThreadsTracking")
    @XRegistry
    public static class EnableThreadsTracking {
    }

    protected class ThreadDelegate
    implements FileEventHandler {
        protected final boolean isLongRunning;
        protected final Thread owner = Thread.currentThread();
        protected final Set<File> files = new HashSet<File>();

        protected ThreadDelegate(boolean isLongRunning) {
            this.isLongRunning = isLongRunning;
        }

        @Override
        public void onFile(File file, Object marker) {
            if (!this.owner.equals(Thread.currentThread())) {
                return;
            }
            if (this.isLongRunning) {
                FileEventTracker.this.gc.onFile(file, marker);
            }
            this.files.add(file);
        }
    }

    protected static class GCDelegate
    implements FileEventHandler {
        protected FileCleaningTracker delegate = new FileCleaningTracker();

        protected GCDelegate() {
        }

        @Override
        public void onFile(File file, Object marker) {
            this.delegate.track(file, marker, (FileDeleteStrategy)deleteStrategy);
        }
    }

    static class SafeFileDeleteStrategy
    extends FileDeleteStrategy {
        protected CopyOnWriteArrayList<String> protectedPaths = new CopyOnWriteArrayList();

        protected SafeFileDeleteStrategy() {
            super("DoNotTouchNuxeoBinaries");
        }

        protected void registerProtectedPath(String path) {
            this.protectedPaths.add(path);
        }

        protected boolean isFileProtected(File fileToDelete) {
            for (String path : this.protectedPaths) {
                if (!fileToDelete.getPath().startsWith(path)) continue;
                log.warn((Object)("Protect file " + fileToDelete.getPath() + " from deletion : check usage of Framework.trackFile"));
                return true;
            }
            return false;
        }

        protected boolean doDelete(File fileToDelete) throws IOException {
            if (!this.isFileProtected(fileToDelete)) {
                return super.doDelete(fileToDelete);
            }
            return false;
        }
    }
}

