/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.packages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.nuxeo.connect.data.DownloadablePackage;
import org.nuxeo.connect.packages.PackageSource;
import org.nuxeo.connect.packages.dependencies.TargetPlatformFilterHelper;
import org.nuxeo.connect.platform.PlatformId;
import org.nuxeo.connect.update.PackageState;
import org.nuxeo.connect.update.PackageType;

public abstract class AbstractPackageSource
implements PackageSource {
    protected String id;
    protected String name;

    @Override
    public List<DownloadablePackage> listPackages(PackageType type) {
        return this.listPackages(type, null);
    }

    @Override
    public List<DownloadablePackage> listPackages(PackageType type, PlatformId currentTargetPlatform) {
        List<DownloadablePackage> all = this.listPackages();
        return all.stream().filter(pkg -> !(pkg.getPackageState() == PackageState.REMOTE && !TargetPlatformFilterHelper.isCompatibleWithTargetPlatform(pkg, currentTargetPlatform) || type != null && !type.equals((Object)pkg.getType()))).collect(Collectors.toList());
    }

    @Override
    public void flushCache() {
    }

    @Override
    public Collection<? extends DownloadablePackage> listPackagesByName(String packageName) {
        return this.listPackagesByName(packageName, null);
    }

    @Override
    public Collection<? extends DownloadablePackage> listPackagesByName(String packageName, PlatformId currentTargetPlatform) {
        ArrayList<DownloadablePackage> result = new ArrayList<DownloadablePackage>();
        for (DownloadablePackage pkg : this.listPackages(null, currentTargetPlatform)) {
            if (!packageName.equals(pkg.getName())) continue;
            result.add(pkg);
        }
        return result;
    }

    @Override
    public List<DownloadablePackage> listStudioPackages() {
        return this.listStudioPackages(null);
    }

    @Override
    public List<DownloadablePackage> listStudioPackages(PlatformId currentTargetPlatform) {
        return this.listPackages(PackageType.STUDIO, currentTargetPlatform);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getId() {
        return this.id;
    }
}

