/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.bulk.action.computation;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.core.bulk.BulkCodecs;
import org.nuxeo.ecm.core.bulk.BulkService;
import org.nuxeo.ecm.core.bulk.action.computation.AbstractTransientBlobComputation;
import org.nuxeo.ecm.core.bulk.message.BulkCommand;
import org.nuxeo.ecm.core.bulk.message.BulkStatus;
import org.nuxeo.ecm.core.bulk.message.DataBucket;
import org.nuxeo.lib.stream.codec.Codec;
import org.nuxeo.lib.stream.computation.ComputationContext;
import org.nuxeo.lib.stream.computation.Record;
import org.nuxeo.lib.stream.computation.internals.ComputationContextImpl;
import org.nuxeo.runtime.api.Framework;

public class MakeBlob
extends AbstractTransientBlobComputation {
    private static final Logger log = LogManager.getLogger(MakeBlob.class);
    public static final String NAME = "bulk/makeBlob";
    protected static final long CHECK_DELAY_MS = 1000L;
    protected static final String SORT_STREAM = "o1";
    protected static final String ZIP_STREAM = "o2";
    protected static final String EXPOSE_BLOB_STREAM = "o3";
    protected static final int NB_OUTPUT_STREAMS = 3;
    protected final Map<String, Long> counters = new HashMap<String, Long>();
    protected final Map<String, Long> totals = new HashMap<String, Long>();
    protected final Map<String, DataBucket> lastBuckets = new HashMap<String, DataBucket>();
    protected final boolean produceImmediate;

    public MakeBlob() {
        this(false);
    }

    public MakeBlob(boolean produceImmediate) {
        super(NAME, 3);
        this.produceImmediate = produceImmediate;
    }

    @Override
    public void init(ComputationContext context) {
        super.init(context);
        context.setTimer("check", System.currentTimeMillis() + 1000L);
    }

    public void processTimer(ComputationContext context, String key, long timestamp) {
        List<String> commands = this.counters.keySet().stream().filter(commandId -> !this.totals.containsKey(commandId) && this.counters.get(commandId) >= this.getTotal((String)commandId)).collect(Collectors.toList());
        commands.forEach(commandId -> this.finishBlob(context, (String)commandId));
        context.setTimer("check", System.currentTimeMillis() + 1000L);
    }

    public void processRecord(ComputationContext context, String documentIdsStreamName, Record record) {
        Codec<DataBucket> codec = BulkCodecs.getDataBucketCodec();
        DataBucket in = (DataBucket)codec.decode(record.getData());
        String commandId = in.getCommandId();
        long nbDocuments = in.getCount();
        this.appendToFile(commandId, in.getData());
        if (this.counters.containsKey(commandId)) {
            this.counters.put(commandId, nbDocuments + this.counters.get(commandId));
        } else {
            this.counters.put(commandId, nbDocuments);
        }
        this.lastBuckets.put(commandId, in);
        if (this.counters.get(commandId) < this.getTotal(commandId)) {
            return;
        }
        this.finishBlob(context, commandId);
    }

    protected Long getTotal(String commandId) {
        if (!this.totals.containsKey(commandId)) {
            long total = ((BulkStatus)((BulkService)Framework.getService(BulkService.class)).getStatus((Serializable)((Object)commandId))).getTotal();
            if (total == 0L) {
                return Long.MAX_VALUE;
            }
            this.totals.put(commandId, total);
        }
        return this.totals.get(commandId);
    }

    protected Path appendToFile(String commandId, byte[] content) {
        Path path = this.createTemp(commandId);
        try (FileOutputStream stream = new FileOutputStream(path.toFile(), true);){
            stream.write(content);
            stream.flush();
        }
        catch (IOException e) {
            log.error("Unable to write content", (Throwable)e);
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void appendHeaderFooterToFile(Path filePath, String commandId, byte[] header, byte[] footer) {
        if (header.length == 0 && footer.length == 0) {
            return;
        }
        try {
            Path tmpPath = Files.move(filePath, this.createTemp("tmp" + commandId), StandardCopyOption.REPLACE_EXISTING);
            try (InputStream is = Files.newInputStream(tmpPath, new OpenOption[0]);
                 FileOutputStream os = new FileOutputStream(filePath.toFile(), true);){
                if (header.length > 0) {
                    os.write(header);
                }
                IOUtils.copy((InputStream)is, (OutputStream)os);
                if (footer.length > 0) {
                    os.write(footer);
                }
                os.flush();
            }
            finally {
                Files.delete(tmpPath);
            }
        }
        catch (IOException e) {
            log.error("Unable to append header and footer", (Throwable)e);
        }
    }

    protected String saveInTransientStore(String commandId, String storeName) {
        Path path = this.createTemp(commandId);
        this.storeBlob((Blob)new FileBlob(path.toFile()), commandId, storeName);
        try {
            Files.delete(path);
        }
        catch (IOException e) {
            log.error("Unable to delete file", (Throwable)e);
        }
        return this.getTransientStoreKey(commandId);
    }

    protected String getOutputStream(String commandId) {
        String outputStream = EXPOSE_BLOB_STREAM;
        BulkCommand command = ((BulkService)Framework.getService(BulkService.class)).getCommand(commandId);
        boolean sort = true;
        boolean zip = false;
        if (command != null) {
            if (command.getParam("sort") != null) {
                sort = (Boolean)command.getParam("sort");
            }
            if (command.getParam("zip") != null) {
                zip = (Boolean)command.getParam("zip");
            }
        }
        if (sort) {
            outputStream = SORT_STREAM;
        } else if (zip) {
            outputStream = ZIP_STREAM;
        }
        return outputStream;
    }

    protected void finishBlob(ComputationContext context, String commandId) {
        String outputStream = this.getOutputStream(commandId);
        DataBucket in = this.lastBuckets.get(commandId);
        if (!SORT_STREAM.equals(outputStream)) {
            this.appendHeaderFooterToFile(this.createTemp(commandId), commandId, in.getHeader(), in.getFooter());
        }
        String storeName = ((BulkStatus)((BulkService)Framework.getService(BulkService.class)).getStatus((Serializable)((Object)commandId))).getAction();
        String value = this.saveInTransientStore(commandId, storeName);
        DataBucket out = new DataBucket(commandId, (long)this.totals.get(commandId), value, in.getHeaderAsString(), in.getFooterAsString());
        Codec<DataBucket> codec = BulkCodecs.getDataBucketCodec();
        if (this.produceImmediate) {
            ((ComputationContextImpl)context).produceRecordImmediate(outputStream, Record.of((String)commandId, (byte[])codec.encode((Object)out)));
        } else {
            context.produceRecord(outputStream, Record.of((String)commandId, (byte[])codec.encode((Object)out)));
        }
        this.totals.remove(commandId);
        this.counters.remove(commandId);
        this.lastBuckets.remove(commandId);
        if (this.counters.isEmpty()) {
            context.askForCheckpoint();
        }
    }
}

