/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.bulk.computation;

import org.nuxeo.ecm.core.bulk.BulkCodecs;
import org.nuxeo.ecm.core.bulk.BulkService;
import org.nuxeo.ecm.core.bulk.BulkServiceImpl;
import org.nuxeo.ecm.core.bulk.message.BulkStatus;
import org.nuxeo.lib.stream.codec.Codec;
import org.nuxeo.lib.stream.computation.AbstractComputation;
import org.nuxeo.lib.stream.computation.ComputationContext;
import org.nuxeo.lib.stream.computation.Record;
import org.nuxeo.runtime.api.Framework;

public class BulkStatusComputation
extends AbstractComputation {
    public BulkStatusComputation(String name) {
        super(name, 1, 1);
    }

    public void processRecord(ComputationContext context, String inputStreamName, Record record) {
        BulkStatus status;
        Codec<BulkStatus> codec = BulkCodecs.getStatusCodec();
        BulkStatus recordStatus = (BulkStatus)codec.decode(record.getData());
        BulkServiceImpl bulkService = (BulkServiceImpl)Framework.getService(BulkService.class);
        if (!recordStatus.isDelta()) {
            status = recordStatus;
        } else {
            status = bulkService.getStatus(recordStatus.getId());
            if (BulkStatus.State.UNKNOWN.equals((Object)status.getState())) {
                throw new IllegalStateException(String.format("Status with unknown command: %s, offset: %s, record: %s.", recordStatus.getId(), context.getLastOffset(), record));
            }
            status.merge(recordStatus);
        }
        byte[] statusAsBytes = bulkService.setStatus(status);
        if (status.getState() == BulkStatus.State.COMPLETED || recordStatus.getState() == BulkStatus.State.ABORTED) {
            context.produceRecord("o1", status.getId(), statusAsBytes);
        }
        context.askForCheckpoint();
    }
}

