/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.bulk.introspection;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.lib.stream.computation.AbstractComputation;
import org.nuxeo.lib.stream.computation.ComputationContext;
import org.nuxeo.lib.stream.computation.Record;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.kv.KeyValueService;
import org.nuxeo.runtime.kv.KeyValueStore;

public class StreamIntrospectionComputation
extends AbstractComputation {
    private static final Logger log = LogManager.getLogger(StreamIntrospectionComputation.class);
    public static final String NAME = "stream/introspection";
    public static final String INTROSPECTION_KV_STORE = "introspection";
    public static final String INTROSPECTION_KEY = "streamIntrospection";
    protected static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    protected final Map<String, JsonNode> streams = new HashMap<String, JsonNode>();
    protected final Map<String, JsonNode> processors = new HashMap<String, JsonNode>();
    protected final Map<String, JsonNode> metrics = new HashMap<String, JsonNode>();
    protected static final long TTL_SECONDS = 300L;
    protected String model;

    public StreamIntrospectionComputation() {
        super(NAME, 2, 0);
    }

    public void init(ComputationContext context) {
        if (context.isSpareComputation()) {
            log.info("Spare instance nothing to report");
        } else {
            log.warn("Instance elected to introspect Nuxeo Stream activity");
        }
        this.loadModel(this.getKvStore().getString(INTROSPECTION_KEY));
    }

    protected void loadModel(String modelJson) {
        this.streams.clear();
        this.processors.clear();
        this.metrics.clear();
        if (StringUtils.isBlank((CharSequence)modelJson)) {
            this.model = null;
            return;
        }
        try {
            JsonNode modelNode = OBJECT_MAPPER.readTree(modelJson);
            JsonNode node = modelNode.get("streams");
            if (node.isArray()) {
                for (JsonNode item : node) {
                    this.streams.put(item.get("name").asText(), item);
                }
            }
            if ((node = modelNode.get("processors")).isArray()) {
                for (JsonNode item : node) {
                    this.processors.put(this.getProcessorKey(item), item);
                }
            }
            if ((node = modelNode.get("metrics")).isArray()) {
                for (JsonNode item : node) {
                    this.metrics.put(item.get("ip").asText(), item);
                }
            }
            this.model = modelJson;
        }
        catch (JsonProcessingException e) {
            log.error("Unable to parse KV model as JSON {}", (Object)modelJson, (Object)e);
            this.model = null;
        }
    }

    public void processRecord(ComputationContext context, String inputStreamName, Record record) {
        JsonNode json = this.getJson(record);
        if (json != null) {
            if ("i1".equals(inputStreamName)) {
                this.updateStreamsAndProcessors(json);
            } else if ("i2".equals(inputStreamName) && json.has("ip")) {
                this.metrics.put(json.get("ip").asText(), json);
            }
        }
        this.removeOldNodes();
        this.buildModel();
        this.updateModel();
        context.askForCheckpoint();
    }

    protected void updateStreamsAndProcessors(JsonNode node) {
        JsonNode streamsNode = node.get("streams");
        if (streamsNode == null) {
            log.warn("Invalid metric without streams field: {}", (Object)node);
            return;
        }
        if (streamsNode.isArray()) {
            for (JsonNode item : streamsNode) {
                this.streams.put(item.get("name").asText(), item);
            }
        }
        ((ObjectNode)node).remove("streams");
        this.processors.put(this.getProcessorKey(node), node);
    }

    protected String getProcessorKey(JsonNode json) {
        return json.at("/metadata/ip").asText() + ":" + json.at("/metadata/processorName").asText();
    }

    protected void updateModel() {
        KeyValueStore kv = this.getKvStore();
        kv.put(INTROSPECTION_KEY, this.model);
    }

    protected KeyValueStore getKvStore() {
        return ((KeyValueService)Framework.getService(KeyValueService.class)).getKeyValueStore(INTROSPECTION_KV_STORE);
    }

    protected void buildModel() {
        ObjectNode node = OBJECT_MAPPER.createObjectNode();
        ArrayNode streamsNode = OBJECT_MAPPER.createArrayNode();
        streamsNode.addAll(this.streams.values());
        node.set("streams", (JsonNode)streamsNode);
        ArrayNode processorsNode = OBJECT_MAPPER.createArrayNode();
        processorsNode.addAll(this.processors.values());
        node.set("processors", (JsonNode)processorsNode);
        ArrayNode metricsNode = OBJECT_MAPPER.createArrayNode();
        metricsNode.addAll(this.metrics.values());
        node.set("metrics", (JsonNode)metricsNode);
        try {
            this.model = OBJECT_MAPPER.writer().writeValueAsString((Object)node);
        }
        catch (JsonProcessingException e) {
            log.error("Cannot build JSON model", (Throwable)e);
            this.model = "{}";
        }
    }

    protected void removeOldNodes() {
        long now = System.currentTimeMillis() / 1000L;
        List<String> toRemove = this.metrics.values().stream().filter(json -> now - json.get("timestamp").asLong() > 300L).map(json -> json.get("ip").asText()).collect(Collectors.toList());
        log.debug("Removing nodes: {}", toRemove);
        toRemove.forEach(this.metrics::remove);
        toRemove.forEach(ip -> {
            List<String> toRemoveProcessors = this.processors.keySet().stream().filter(key -> key.startsWith((String)ip)).collect(Collectors.toList());
            toRemoveProcessors.forEach(this.processors::remove);
        });
    }

    protected JsonNode getJson(Record record) {
        String json = new String(record.getData(), StandardCharsets.UTF_8);
        try {
            return OBJECT_MAPPER.readTree(json);
        }
        catch (JsonProcessingException e) {
            log.error("Invalid JSON from record {}: {}", (Object)record, (Object)json, (Object)e);
            return null;
        }
    }
}

