/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.bulk.introspection;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.lib.stream.log.Name;

public class StreamIntrospectionConverter {
    protected static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    protected final String json;
    protected final JsonNode root;

    public StreamIntrospectionConverter(String json) {
        this.json = json;
        try {
            this.root = OBJECT_MAPPER.readTree(json);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Invalid JSON: " + json, e);
        }
    }

    public String getPuml() {
        StringBuilder ret = new StringBuilder();
        ret.append("@startuml\n");
        Map<String, String> streamMetrics = this.parseMetrics();
        ret.append(this.getPumlHeader("Stream Introspection at " + streamMetrics.get("date")));
        JsonNode node = this.root.get("streams");
        if (node.isArray()) {
            for (JsonNode item : node) {
                this.dumpStream(ret, item, streamMetrics);
            }
        }
        if ((node = this.root.get("processors")).isArray()) {
            for (JsonNode item : node) {
                JsonNode topologies;
                String host = item.at("/metadata/ip").asText();
                JsonNode computations = item.get("computations");
                if (computations.isArray()) {
                    for (JsonNode computation : computations) {
                        this.dumpComputation(host, ret, computation, streamMetrics);
                    }
                }
                if (!(topologies = item.get("topology")).isArray()) continue;
                for (JsonNode topo : topologies) {
                    String comment = "";
                    String source = topo.get(0).asText();
                    String target = topo.get(1).asText();
                    if (target.startsWith("computation:")) {
                        String stream = source.replace("stream:", "");
                        String computation = target.replace("computation:", "");
                        String lag = streamMetrics.get(stream + ":" + computation + ":lag");
                        String latency = streamMetrics.get(stream + ":" + computation + ":latency");
                        String pos = streamMetrics.get(stream + ":" + computation + ":pos");
                        String end = this.getStreamEnd(streamMetrics, stream);
                        if (lag != null && !"0".equals(lag)) {
                            comment = String.format(": %s/%s lag: %s, latency: %ss", pos, end, lag, latency);
                        }
                    }
                    ret.append(String.format("%s==>%s%s%n", this.getPumlIdentifierForHost(host, source), this.getPumlIdentifierForHost(host, target), comment));
                }
            }
        }
        ret.append("@enduml\n");
        return ret.toString();
    }

    protected Map<String, String> parseMetrics() {
        HashMap<String, String> streamMetrics = new HashMap<String, String>();
        JsonNode node = this.root.get("metrics");
        long timestamp = 0L;
        if (node.isArray()) {
            for (JsonNode host : node) {
                JsonNode hostMetrics;
                String hostIp = host.get("ip").asText();
                long metricTimestamp = host.get("timestamp").asLong();
                if (metricTimestamp > timestamp) {
                    timestamp = metricTimestamp;
                }
                if (!(hostMetrics = host.get("metrics")).isArray()) continue;
                for (JsonNode metric : hostMetrics) {
                    int value;
                    Object computationName;
                    if (metric.has("stream")) {
                        String key = metric.get("k").asText();
                        String streamName = Name.urnOfId((String)metric.get("stream").asText());
                        String computationName2 = Name.urnOfId((String)metric.get("group").asText());
                        if ("nuxeo.streams.global.stream.group.end".equals(key)) {
                            streamMetrics.put(streamName + ":end", metric.get("v").asText());
                            continue;
                        }
                        if ("nuxeo.streams.global.stream.group.lag".equals(key)) {
                            streamMetrics.put(streamName + ":" + computationName2 + ":lag", metric.get("v").asText());
                            continue;
                        }
                        if ("nuxeo.streams.global.stream.group.latency".equals(key)) {
                            streamMetrics.put(streamName + ":" + computationName2 + ":latency", this.getNiceDouble(metric.get("v").asDouble() / 1000.0));
                            continue;
                        }
                        if (!"nuxeo.streams.global.stream.group.pos".equals(key)) continue;
                        streamMetrics.put(streamName + ":" + computationName2 + ":pos", metric.get("v").asText());
                        continue;
                    }
                    if (metric.get("k").asText().endsWith("processRecord")) {
                        int count = metric.get("count").asInt();
                        if (count == 0) continue;
                        computationName = Name.urnOfId((String)metric.get("computation").asText());
                        streamMetrics.put((String)computationName + ":" + hostIp + ":count", metric.get("count").asText());
                        streamMetrics.put((String)computationName + ":" + hostIp + ":sum", this.getNiceDouble3(metric.get("sum").asDouble() / 1.0E9));
                        streamMetrics.put((String)computationName + ":" + hostIp + ":p50", this.getNiceDouble3(metric.get("p50").asDouble()));
                        streamMetrics.put((String)computationName + ":" + hostIp + ":mean", this.getNiceDouble3(metric.get("mean").asDouble()));
                        streamMetrics.put((String)computationName + ":" + hostIp + ":p99", this.getNiceDouble3(metric.get("p99").asDouble()));
                        streamMetrics.put((String)computationName + ":" + hostIp + ":rate1m", this.getNiceDouble(metric.get("rate1m").asDouble()));
                        streamMetrics.put((String)computationName + ":" + hostIp + ":rate5m", this.getNiceDouble(metric.get("rate5m").asDouble()));
                        continue;
                    }
                    if (metric.get("k").asText().endsWith("processTimer")) {
                        int count = metric.get("count").asInt();
                        if (count == 0) continue;
                        computationName = Name.urnOfId((String)metric.get("computation").asText());
                        streamMetrics.put((String)computationName + ":" + hostIp + ":timer:count", metric.get("count").asText());
                        streamMetrics.put((String)computationName + ":" + hostIp + ":timer:sum", this.getNiceDouble3(metric.get("sum").asDouble() / 1.0E9));
                        streamMetrics.put((String)computationName + ":" + hostIp + ":timer:p50", this.getNiceDouble3(metric.get("p50").asDouble()));
                        streamMetrics.put((String)computationName + ":" + hostIp + ":timer:mean", this.getNiceDouble3(metric.get("mean").asDouble()));
                        streamMetrics.put((String)computationName + ":" + hostIp + ":timer:p99", this.getNiceDouble3(metric.get("p99").asDouble()));
                        streamMetrics.put((String)computationName + ":" + hostIp + ":timer:rate1m", this.getNiceDouble(metric.get("rate1m").asDouble()));
                        streamMetrics.put((String)computationName + ":" + hostIp + ":timer:rate5m", this.getNiceDouble(metric.get("rate5m").asDouble()));
                        continue;
                    }
                    if (metric.get("k").asText().endsWith("computation.failure")) {
                        int failure = metric.get("v").asInt();
                        if (failure <= 0) continue;
                        computationName = Name.urnOfId((String)metric.get("computation").asText()) + ":" + hostIp;
                        streamMetrics.put((String)computationName + ":failure", metric.get("v").asText());
                        continue;
                    }
                    if (metric.get("k").asText().endsWith("stream.failure")) {
                        int value2 = metric.get("v").asInt();
                        if (value2 <= 0) continue;
                        streamMetrics.put(hostIp + ":failure", metric.get("v").asText());
                        continue;
                    }
                    if (!metric.get("k").asText().endsWith("computation.skippedRecord") || (value = metric.get("v").asInt()) <= 0) continue;
                    computationName = Name.urnOfId((String)metric.get("computation").asText()) + ":" + hostIp;
                    streamMetrics.put((String)computationName + ":skipped", metric.get("v").asText());
                }
            }
        }
        streamMetrics.put("timestamp", String.valueOf(timestamp));
        streamMetrics.put("date", Instant.ofEpochSecond(timestamp).toString());
        return streamMetrics;
    }

    protected String getNiceDouble(Double number) {
        return String.format("%.2f", number);
    }

    protected String getNiceDouble3(Double number) {
        return String.format("%.3f", number);
    }

    protected String getPumlHeader(String title) {
        return "title " + title + "\n\nskinparam defaultFontName Courier\nskinparam handwritten false\nskinparam queueBackgroundColor LightYellow\nskinparam nodeBackgroundColor Azure\nskinparam componentBackgroundColor Azure\nskinparam nodebackgroundColor<<failure>> Yellow\nskinparam componentbackgroundColor<<failure>> Yellow\nskinparam component {\n  BorderColor black\n  ArrowColor #CC6655\n}\n";
    }

    protected String getPumlIdentifierForHost(String host, String id) {
        if (id.startsWith("computation:")) {
            return this.getPumlIdentifier(id + ":" + host);
        }
        return this.getPumlIdentifier(id);
    }

    protected void dumpStream(StringBuilder ret, JsonNode item, Map<String, String> metrics) {
        String name = item.get("name").asText();
        String partitions = item.get("partitions").asText();
        String codec = item.get("codec").asText();
        ret.append(String.format("queue %s [%s%n----%npartitions: %s%ncodec: %s%n-----%nrecords: %s]%n", this.getPumlIdentifier("stream:" + name), name, partitions, codec, this.getStreamEnd(metrics, name)));
    }

    protected String getStreamEnd(Map<String, String> metrics, String name) {
        String ret = metrics.get(name + ":end");
        return ret == null ? "0" : ret;
    }

    protected void dumpComputation(String host, StringBuilder ret, JsonNode item, Map<String, String> metrics) {
        String name = item.get("name").asText();
        String threads = item.get("threads").asText();
        String continueOnFailure = item.get("continueOnFailure").asText();
        String failure = "";
        if (metrics.containsKey(name + ":" + host + ":failure")) {
            failure = " <<failure>>";
        }
        ret.append(String.format("component %s %s[%s%n----%nthreads: %s%ncontinue on failure: %s%n%s%s]%n", this.getPumlIdentifier("computation:" + name + ":" + host), failure, name + " on " + host, threads, continueOnFailure, this.getBatchInfo(item), this.getComputationMetrics(host, name, item, metrics)));
    }

    protected String getComputationMetrics(String host, String name, JsonNode item, Map<String, String> metrics) {
        Object ret = "";
        String baseKey = name + ":" + host;
        if (!metrics.containsKey(baseKey + ":count")) {
            return ret;
        }
        ret = (String)ret + "\n----\n";
        if (metrics.containsKey(baseKey + ":failure")) {
            ret = (String)ret + "FAILURE: " + metrics.get(baseKey + ":failure") + "\n";
        }
        ret = (String)ret + "record count: " + metrics.get(baseKey + ":count") + ", total: " + metrics.get(baseKey + ":sum") + "s\n";
        if (metrics.containsKey(baseKey + ":skipped")) {
            ret = (String)ret + "record skipped: " + metrics.get(baseKey + ":skipped") + "\n";
        }
        ret = (String)ret + "mean: " + metrics.get(baseKey + ":mean") + "s, p50: " + metrics.get(baseKey + ":p50") + "s, p99: " + metrics.get(baseKey + ":p99") + "s\n";
        ret = (String)ret + "rate 1min: " + metrics.get(baseKey + ":rate1m") + "op/s, 5min: " + metrics.get(baseKey + ":rate5m") + "op/s";
        if (!metrics.containsKey(baseKey + ":timer:count")) {
            return ret;
        }
        ret = (String)ret + "\n----\n";
        baseKey = baseKey + ":timer";
        ret = (String)ret + "timer count: " + metrics.get(baseKey + ":count") + ", total: " + metrics.get(baseKey + ":sum") + "s\n";
        ret = (String)ret + "mean: " + metrics.get(baseKey + ":mean") + "s, p50: " + metrics.get(baseKey + ":p50") + "s, p99: " + metrics.get(baseKey + ":p99") + "s\n";
        ret = (String)ret + "rate 5min: " + metrics.get(baseKey + ":rate5m") + "op/s";
        return ret;
    }

    protected String getBatchInfo(JsonNode item) {
        Object ret = "";
        int batchCapacity = item.get("batchCapacity").asInt();
        if (batchCapacity > 1) {
            int batchThresholdMs = item.get("batchCapacity").asInt();
            ret = (String)ret + "batch " + item.get("batchCapacity").asText() + " " + batchThresholdMs + "ms\n";
        } else {
            ret = (String)ret + "no batch\n";
        }
        int retry = item.get("maxRetries").asInt();
        ret = retry > 1 ? (String)ret + "max retry: " + item.get("maxRetries").asText() + ", delay: " + item.get("retryDelayMs").asText() + "ms" : (String)ret + "no retry";
        return ret;
    }

    protected String getPumlIdentifier(String name) {
        return name.replaceAll("[^a-zA-Z0-9]", ".");
    }
}

