/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.codec;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.lib.stream.codec.Codec;
import org.nuxeo.runtime.codec.CodecDescriptor;
import org.nuxeo.runtime.codec.CodecFactory;
import org.nuxeo.runtime.codec.CodecService;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;

public class CodecServiceImpl
extends DefaultComponent
implements CodecService {
    private static final Logger log = LogManager.getLogger(CodecServiceImpl.class);
    public static final String XP_CODEC = "codec";
    protected final Map<String, CodecFactory> codecFactories = new HashMap<String, CodecFactory>();

    public void start(ComponentContext context) {
        super.start(context);
        List descriptors = this.getRegistryContributions(XP_CODEC);
        for (CodecDescriptor descriptor : descriptors) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = descriptor.klass::getSimpleName;
            log.debug("Creating CodecFactory : {}", supplierArray);
            try {
                CodecFactory factory = descriptor.klass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                factory.init(descriptor.options);
                this.codecFactories.put(descriptor.getId(), factory);
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalArgumentException("Invalid class: " + this.getClass(), e);
            }
        }
    }

    public void stop(ComponentContext context) throws InterruptedException {
        super.stop(context);
        this.codecFactories.clear();
    }

    public int getApplicationStartedOrder() {
        return -600;
    }

    @Override
    public <T> Codec<T> getCodec(String codecName, Class<T> objectClass) {
        if (!this.codecFactories.containsKey(codecName)) {
            throw new IllegalArgumentException(String.format("Codec not found: %s, requested for class: %s", codecName, objectClass));
        }
        return this.codecFactories.get(codecName).newCodec(objectClass);
    }
}

