/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.kafka;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.launcher.config.ConfigurationException;
import org.nuxeo.launcher.config.ConfigurationHolder;
import org.nuxeo.launcher.config.backingservices.BackingChecker;
import org.nuxeo.lib.stream.log.Name;
import org.nuxeo.lib.stream.log.kafka.KafkaLogManager;
import org.nuxeo.runtime.kafka.KafkaConfigDescriptor;

public class KafkaChecker
implements BackingChecker {
    private static final Logger log = LogManager.getLogger(KafkaChecker.class);
    private static final String KAFKA_ENABLED_PROP = "kafka.enabled";
    private static final String CONFIG_NAME = "kafka-config.xml";

    public boolean accepts(ConfigurationHolder configHolder) {
        if (!"true".equals(configHolder.getProperty(KAFKA_ENABLED_PROP))) {
            log.debug("Checker skipped because Kafka is disabled");
            return false;
        }
        return true;
    }

    public void check(ConfigurationHolder configHolder) throws ConfigurationException {
        KafkaConfigDescriptor config = (KafkaConfigDescriptor)this.getDescriptor(configHolder, CONFIG_NAME, KafkaConfigDescriptor.class);
        try (KafkaLogManager manager = new KafkaLogManager(config.topicPrefix, config.producerProperties.properties, config.consumerProperties.properties);){
            manager.exists(Name.ofUrn((String)"input/null"));
        }
        catch (Exception e) {
            throw new ConfigurationException("Unable to reach Kafka using: " + config.producerProperties.properties, (Throwable)e);
        }
    }
}

