/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.stream;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.common.xmap.registry.XEnable;
import org.nuxeo.common.xmap.registry.XRegistry;
import org.nuxeo.common.xmap.registry.XRegistryId;

@XObject(value="logConfig")
@XRegistry(enable=false, compatWarnOnMerge=true)
public class LogConfigDescriptor {
    public static final String SEP = ":";
    @XNode(value="@enable", fallback="@enabled", defaultAssignment="true")
    @XEnable
    protected boolean isEnabled;
    @XNode(value="@default", defaultAssignment="false")
    protected boolean isDefault;
    @XNode(value="@name")
    @XRegistryId
    public String name;
    @XNode(value="@type")
    public String type;
    @XNodeMap(value="option", key="@name", type=HashMap.class, componentType=String.class)
    public Map<String, String> options = new HashMap<String, String>();
    @XNodeList(value="log", type=ArrayList.class, componentType=LogDescriptor.class)
    public List<LogDescriptor> logs = new ArrayList<LogDescriptor>();
    @XNodeList(value="match", type=ArrayList.class, componentType=LogMatchDescriptor.class)
    public List<LogMatchDescriptor> matches = new ArrayList<LogMatchDescriptor>();

    public String getId() {
        return this.name;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public boolean onlyLogDeclaration() {
        return this.name == null && this.type == null;
    }

    public List<String> getPatterns() {
        return this.matches.stream().map(match -> match.getId()).collect(Collectors.toList());
    }

    @XObject(value="match")
    public static class LogMatchDescriptor {
        @XNode(value="@name")
        public String name;
        @XNode(value="@group")
        public String group;

        public String getId() {
            return this.group != null && !this.group.isBlank() ? this.name + LogConfigDescriptor.SEP + this.group : this.name;
        }
    }

    @XObject(value="log")
    public static class LogDescriptor {
        public static final Integer DEFAULT_PARTITIONS = 4;
        @XNode(value="@name")
        public String name;
        @XNode(value="@size")
        public Integer size = DEFAULT_PARTITIONS;

        public String getId() {
            return this.name;
        }
    }
}

