/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.dbs;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.nuxeo.ecm.core.api.PartialList;
import org.nuxeo.ecm.core.api.ScrollResult;
import org.nuxeo.ecm.core.api.lock.LockManager;
import org.nuxeo.ecm.core.query.sql.model.OrderByClause;
import org.nuxeo.ecm.core.storage.State;
import org.nuxeo.ecm.core.storage.dbs.DBSExpressionEvaluator;
import org.nuxeo.ecm.core.storage.dbs.DBSTransactionState;

public interface DBSConnection
extends AutoCloseable,
LockManager {
    @Override
    public void close();

    public String getRootId();

    public String generateNewId();

    public State readState(String var1);

    default public State readPartialState(String id, Collection<String> keys) {
        return this.readState(id);
    }

    public List<State> readStates(List<String> var1);

    public void createState(State var1);

    default public void createStates(List<State> states) {
        states.forEach(this::createState);
    }

    public void updateState(String var1, State.StateDiff var2, DBSTransactionState.ChangeTokenUpdater var3);

    public void deleteStates(Set<String> var1);

    public State readChildState(String var1, String var2, Set<String> var3);

    public boolean hasChild(String var1, String var2, Set<String> var3);

    public List<State> queryKeyValue(String var1, Object var2, Set<String> var3);

    public List<State> queryKeyValue(String var1, Object var2, String var3, Object var4, Set<String> var5);

    public List<State> queryKeyValueWithOperator(String var1, Object var2, String var3, DBSQueryOperator var4, Object var5, Set<String> var6);

    public Stream<State> getDescendants(String var1, Set<String> var2);

    default public Stream<State> getDescendants(String id, Set<String> keys, int limit) {
        return this.getDescendants(id, keys);
    }

    public boolean queryKeyValuePresence(String var1, String var2, Set<String> var3);

    public PartialList<Map<String, Serializable>> queryAndFetch(DBSExpressionEvaluator var1, OrderByClause var2, boolean var3, int var4, int var5, int var6);

    public ScrollResult<String> scroll(DBSExpressionEvaluator var1, int var2, int var3);

    public ScrollResult<String> scroll(String var1);

    public void begin();

    public void commit();

    public void rollback();

    public static enum DBSQueryOperator {
        NOT_IN,
        IN;

    }
}

