/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.dbs;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Lock;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.lock.LockManager;
import org.nuxeo.ecm.core.api.repository.FulltextConfiguration;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.model.Session;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.TypeConstants;
import org.nuxeo.ecm.core.schema.types.ComplexType;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.storage.FulltextConfigurationFactory;
import org.nuxeo.ecm.core.storage.FulltextDescriptor;
import org.nuxeo.ecm.core.storage.dbs.DBSConnection;
import org.nuxeo.ecm.core.storage.dbs.DBSRepository;
import org.nuxeo.ecm.core.storage.dbs.DBSRepositoryDescriptor;
import org.nuxeo.ecm.core.storage.dbs.DBSSession;
import org.nuxeo.ecm.core.storage.lock.LockManagerService;
import org.nuxeo.runtime.api.Framework;

public abstract class DBSRepositoryBase
implements DBSRepository {
    private static final Log log = LogFactory.getLog(DBSRepositoryBase.class);
    public static final String TYPE_ROOT = "Root";
    public static final boolean DEBUG_UUIDS = false;
    public static final String UUID_ZERO = "00000000-0000-0000-0000-000000000000";
    public static final String UUID_ZERO_DEBUG = "UUID_0";
    protected final IdType idType;
    protected final String repositoryName;
    protected final FulltextConfiguration fulltextConfiguration;
    protected final BlobManager blobManager;
    protected LockManager lockManager;
    protected final boolean changeTokenEnabled;
    protected boolean selfRegisteredLockManager = false;

    public DBSRepositoryBase(String repositoryName, DBSRepositoryDescriptor descriptor) {
        this.repositoryName = repositoryName;
        String idt = descriptor.idType;
        List<IdType> allowed = this.getAllowedIdTypes();
        if (StringUtils.isBlank((CharSequence)idt)) {
            idt = allowed.get(0).name();
        }
        try {
            this.idType = IdType.valueOf(idt);
            if (!allowed.contains((Object)this.idType)) {
                throw new IllegalArgumentException("Invalid id type: " + idt);
            }
        }
        catch (IllegalArgumentException e) {
            throw new NuxeoException("Unknown id type: " + idt + ", allowed: " + allowed);
        }
        FulltextDescriptor fulltextDescriptor = descriptor.getFulltextDescriptor();
        this.fulltextConfiguration = fulltextDescriptor.getFulltextDisabled() ? null : FulltextConfigurationFactory.make((FulltextDescriptor)fulltextDescriptor);
        this.changeTokenEnabled = descriptor.isChangeTokenEnabled();
        this.blobManager = (BlobManager)Framework.getService(BlobManager.class);
        this.initBlobsPaths();
        this.initLockManager();
    }

    public abstract List<IdType> getAllowedIdTypes();

    public IdType getIdType() {
        return this.idType;
    }

    public void shutdown() {
        LockManagerService lms;
        if (this.selfRegisteredLockManager && (lms = (LockManagerService)Framework.getService(LockManagerService.class)) != null) {
            lms.unregisterLockManager(this.getLockManagerName());
        }
    }

    public String getName() {
        return this.repositoryName;
    }

    public FulltextConfiguration getFulltextConfiguration() {
        return this.fulltextConfiguration;
    }

    protected String getLockManagerName() {
        return this.getName();
    }

    protected void initLockManager() {
        String lockManagerName = this.getLockManagerName();
        LockManagerService lockManagerService = (LockManagerService)Framework.getService(LockManagerService.class);
        this.lockManager = lockManagerService.getLockManager(lockManagerName);
        if (this.lockManager == null) {
            this.lockManager = this;
            log.info((Object)("Repository " + this.repositoryName + " using own lock manager"));
            lockManagerService.registerLockManager(lockManagerName, this.lockManager);
            this.selfRegisteredLockManager = true;
        } else {
            this.selfRegisteredLockManager = false;
            log.info((Object)("Repository " + this.repositoryName + " using lock manager " + this.lockManager));
        }
    }

    @Override
    public LockManager getLockManager() {
        return this.lockManager;
    }

    public Lock getLock(String id) {
        try (DBSConnection connection = this.getConnection();){
            Lock lock = connection.getLock(id);
            return lock;
        }
    }

    public Lock setLock(String id, Lock lock) {
        try (DBSConnection connection = this.getConnection();){
            Lock lock2 = connection.setLock(id, lock);
            return lock2;
        }
    }

    public Lock removeLock(String id, String owner) {
        try (DBSConnection connection = this.getConnection();){
            Lock lock = connection.removeLock(id, owner);
            return lock;
        }
    }

    protected abstract void initBlobsPaths();

    @Override
    public BlobManager getBlobManager() {
        return this.blobManager;
    }

    @Override
    public boolean isFulltextDisabled() {
        return this.fulltextConfiguration == null;
    }

    @Override
    public boolean isFulltextStoredInBlob() {
        return this.fulltextConfiguration != null && this.fulltextConfiguration.fulltextStoredInBlob;
    }

    @Override
    public boolean isFulltextSearchDisabled() {
        return this.isFulltextDisabled() || this.isFulltextStoredInBlob() || this.fulltextConfiguration.fulltextSearchDisabled;
    }

    @Override
    public boolean isChangeTokenEnabled() {
        return this.changeTokenEnabled;
    }

    public Session getSession() {
        return new DBSSession(this);
    }

    protected static abstract class BlobFinder {
        protected final Set<String> schemaDone = new HashSet<String>();
        protected final Deque<String> path = new ArrayDeque<String>();

        protected BlobFinder() {
        }

        public void visit() {
            SchemaManager schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
            for (DocumentType documentType : schemaManager.getDocumentTypes()) {
                this.visitSchemas(documentType.getSchemas());
            }
            for (DocumentType documentType : schemaManager.getFacets()) {
                this.visitSchemas(documentType.getSchemas());
            }
        }

        protected void visitSchemas(Collection<Schema> schemas) {
            for (Schema schema : schemas) {
                if (!this.schemaDone.add(schema.getName())) continue;
                this.visitComplexType((ComplexType)schema);
            }
        }

        protected void visitComplexType(ComplexType complexType) {
            if (TypeConstants.isContentType((Type)complexType)) {
                this.recordBlobPath();
                return;
            }
            for (Field field : complexType.getFields()) {
                this.visitField(field);
            }
        }

        protected abstract void recordBlobPath();

        protected void visitField(Field field) {
            Type type = field.getType();
            if (!type.isSimpleType()) {
                if (type.isComplexType()) {
                    String name = field.getName().getPrefixedName();
                    this.path.addLast(name);
                    this.visitComplexType((ComplexType)type);
                    this.path.removeLast();
                } else {
                    Type fieldType = ((ListType)type).getFieldType();
                    if (!fieldType.isSimpleType()) {
                        String name = field.getName().getPrefixedName();
                        this.path.addLast(name);
                        this.visitComplexType((ComplexType)fieldType);
                        this.path.removeLast();
                    }
                }
            }
        }
    }

    public static enum IdType {
        varchar,
        uuid,
        sequence,
        sequenceHexRandomized;

    }
}

