/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.search.core;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.nuxeo.ecm.core.io.marshallers.json.EntityJsonReader;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.platform.search.core.SavedSearchRequest;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class SavedSearchRequestReader
extends EntityJsonReader<SavedSearchRequest> {
    public SavedSearchRequestReader() {
        super("savedSearch");
    }

    protected SavedSearchRequest readEntity(JsonNode jn) throws IOException {
        String id = this.getStringField(jn, "id");
        String title = this.getStringField(jn, "title");
        String queryParams = this.getStringField(jn, "queryParams");
        String query = this.getStringField(jn, "query");
        String queryLanguage = this.getStringField(jn, "queryLanguage");
        String pageProviderName = this.getStringField(jn, "pageProviderName");
        Long pageSize = this.getLongField(jn, "pageSize");
        Long currentPageIndex = this.getLongField(jn, "currentPageIndex");
        Long maxResults = this.getLongField(jn, "maxResults");
        String sortBy = this.getStringField(jn, "sortBy");
        String sortOrder = this.getStringField(jn, "sortOrder");
        String contentViewData = this.getStringField(jn, "contentViewData");
        JsonNode queryParamsNode = jn.has("params") ? jn.get("params") : null;
        HashMap<String, String> params = new HashMap<String, String>();
        ObjectMapper mapper = new ObjectMapper();
        if (queryParamsNode != null) {
            Iterator fields = queryParamsNode.fields();
            while (fields.hasNext()) {
                Map.Entry fieldEntry = (Map.Entry)fields.next();
                params.put((String)fieldEntry.getKey(), ((JsonNode)fieldEntry.getValue()).isTextual() ? ((JsonNode)fieldEntry.getValue()).textValue() : mapper.writeValueAsString(fieldEntry.getValue()));
            }
        }
        return new SavedSearchRequest(id, title, queryParams, params, query, queryLanguage, pageProviderName, pageSize, currentPageIndex, maxResults, sortBy, sortOrder, contentViewData);
    }
}

