/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.range;

import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.bucket.range.AbstractRangeAggregatorFactory;
import org.elasticsearch.search.aggregations.bucket.range.AbstractRangeBuilder;
import org.elasticsearch.search.aggregations.bucket.range.DateRangeAggregatorFactory;
import org.elasticsearch.search.aggregations.bucket.range.InternalDateRange;
import org.elasticsearch.search.aggregations.bucket.range.RangeAggregator;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;

public class DateRangeAggregationBuilder
extends AbstractRangeBuilder<DateRangeAggregationBuilder, RangeAggregator.Range> {
    public static final String NAME = "date_range";
    public static final ObjectParser<DateRangeAggregationBuilder, String> PARSER = ObjectParser.fromBuilder((String)"date_range", DateRangeAggregationBuilder::new);

    public static void registerAggregators(ValuesSourceRegistry.Builder builder) {
        AbstractRangeAggregatorFactory.registerAggregators(builder, NAME);
    }

    public DateRangeAggregationBuilder(String name) {
        super(name, InternalDateRange.FACTORY);
    }

    protected DateRangeAggregationBuilder(DateRangeAggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        super(clone, factoriesBuilder, metadata);
    }

    @Override
    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        return new DateRangeAggregationBuilder(this, factoriesBuilder, metadata);
    }

    public DateRangeAggregationBuilder(StreamInput in) throws IOException {
        super(in, InternalDateRange.FACTORY, RangeAggregator.Range::new);
    }

    @Override
    public String getType() {
        return NAME;
    }

    @Override
    protected ValuesSourceType defaultValueSourceType() {
        return CoreValuesSourceType.DATE;
    }

    public DateRangeAggregationBuilder addRange(String key, String from, String to) {
        this.addRange(new RangeAggregator.Range(key, from, to));
        return this;
    }

    public DateRangeAggregationBuilder addRange(String from, String to) {
        return this.addRange(null, from, to);
    }

    public DateRangeAggregationBuilder addUnboundedTo(String key, String to) {
        this.addRange(new RangeAggregator.Range(key, null, to));
        return this;
    }

    public DateRangeAggregationBuilder addUnboundedTo(String to) {
        return this.addUnboundedTo(null, to);
    }

    public DateRangeAggregationBuilder addUnboundedFrom(String key, String from) {
        this.addRange(new RangeAggregator.Range(key, from, null));
        return this;
    }

    public DateRangeAggregationBuilder addUnboundedFrom(String from) {
        return this.addUnboundedFrom(null, from);
    }

    public DateRangeAggregationBuilder addRange(String key, double from, double to) {
        this.addRange(new RangeAggregator.Range(key, from, to));
        return this;
    }

    public DateRangeAggregationBuilder addRange(double from, double to) {
        return this.addRange(null, from, to);
    }

    public DateRangeAggregationBuilder addUnboundedTo(String key, double to) {
        this.addRange(new RangeAggregator.Range(key, null, to));
        return this;
    }

    public DateRangeAggregationBuilder addUnboundedTo(double to) {
        return this.addUnboundedTo(null, to);
    }

    public DateRangeAggregationBuilder addUnboundedFrom(String key, double from) {
        this.addRange(new RangeAggregator.Range(key, from, null));
        return this;
    }

    public DateRangeAggregationBuilder addUnboundedFrom(double from) {
        return this.addUnboundedFrom(null, from);
    }

    public DateRangeAggregationBuilder addRange(String key, ZonedDateTime from, ZonedDateTime to) {
        this.addRange(new RangeAggregator.Range(key, DateRangeAggregationBuilder.convertDateTime(from), DateRangeAggregationBuilder.convertDateTime(to)));
        return this;
    }

    private static Double convertDateTime(ZonedDateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        return dateTime.toInstant().toEpochMilli();
    }

    public DateRangeAggregationBuilder addRange(ZonedDateTime from, ZonedDateTime to) {
        return this.addRange(null, from, to);
    }

    public DateRangeAggregationBuilder addUnboundedTo(String key, ZonedDateTime to) {
        this.addRange(new RangeAggregator.Range(key, null, DateRangeAggregationBuilder.convertDateTime(to)));
        return this;
    }

    public DateRangeAggregationBuilder addUnboundedTo(ZonedDateTime to) {
        return this.addUnboundedTo(null, to);
    }

    public DateRangeAggregationBuilder addUnboundedFrom(String key, ZonedDateTime from) {
        this.addRange(new RangeAggregator.Range(key, DateRangeAggregationBuilder.convertDateTime(from), null));
        return this;
    }

    public DateRangeAggregationBuilder addUnboundedFrom(ZonedDateTime from) {
        return this.addUnboundedFrom(null, from);
    }

    @Override
    protected DateRangeAggregatorFactory innerBuild(QueryShardContext queryShardContext, ValuesSourceConfig config, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        RangeAggregator.Range[] ranges = this.processRanges(range -> {
            DocValueFormat parser = config.format();
            assert (parser != null);
            double from = range.getFrom();
            double to = range.getTo();
            String fromAsString = range.getFromAsString();
            String toAsString = range.getToAsString();
            if (fromAsString != null) {
                from = parser.parseDouble(fromAsString, false, queryShardContext::nowInMillis);
            } else if (Double.isFinite(from)) {
                from = parser.parseDouble(Long.toString((long)from), false, queryShardContext::nowInMillis);
            }
            if (toAsString != null) {
                to = parser.parseDouble(toAsString, false, queryShardContext::nowInMillis);
            } else if (Double.isFinite(to)) {
                to = parser.parseDouble(Long.toString((long)to), false, queryShardContext::nowInMillis);
            }
            return new RangeAggregator.Range(range.getKey(), from, fromAsString, to, toAsString);
        });
        if (ranges.length == 0) {
            throw new IllegalArgumentException("No [ranges] specified for the [" + this.getName() + "] aggregation");
        }
        return new DateRangeAggregatorFactory(this.name, config, ranges, this.keyed, this.rangeFactory, queryShardContext, parent, subFactoriesBuilder, this.metadata);
    }

    static {
        ValuesSourceAggregationBuilder.declareFields(PARSER, true, true, true);
        PARSER.declareBoolean(AbstractRangeBuilder::keyed, RangeAggregator.KEYED_FIELD);
        PARSER.declareObjectArray((agg, ranges) -> {
            for (RangeAggregator.Range range : ranges) {
                agg.addRange(range);
            }
        }, (p, c) -> (RangeAggregator.Range)RangeAggregator.Range.PARSER.parse(p, null), RangeAggregator.RANGES_FIELD);
    }
}

