/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server;

import org.nuxeo.common.xmap.Context;
import org.nuxeo.common.xmap.XAnnotatedMember;
import org.nuxeo.common.xmap.XAnnotatedObject;
import org.nuxeo.common.xmap.registry.MapRegistry;
import org.nuxeo.ecm.automation.server.RestBinding;
import org.nuxeo.runtime.logging.DeprecationLogger;
import org.w3c.dom.Element;

public class RestBindingRegistry
extends MapRegistry {
    protected <T> T doRegister(Context ctx, XAnnotatedObject xObject, Element element, String extensionId) {
        XAnnotatedMember enable;
        Object contrib;
        RestBinding ob = (RestBinding)xObject.newInstance(ctx, element);
        boolean isChain = ob.chain;
        boolean isDisabled = ob.isDisabled;
        String name = ob.name;
        Object id = isChain ? "Chain." + name : name;
        XAnnotatedMember remove = xObject.getRemove();
        if (remove != null && Boolean.TRUE.equals(remove.getValue(ctx, element))) {
            this.contributions.remove(id);
            return null;
        }
        XAnnotatedMember merge = xObject.getMerge();
        if (merge != null && Boolean.TRUE.equals(merge.getValue(ctx, element))) {
            Object contribution = this.contributions.get(id);
            if (contribution != null && !merge.hasValue(ctx, element)) {
                DeprecationLogger.log((String)String.format("The contribution with id '%s' has been implicitely merged:  the attribute merge=\"true\" should be added to this definition.", id, contribution.getClass().getName()), (String)"11.5");
            }
            contrib = xObject.newInstance(ctx, element, contribution);
        } else {
            contrib = xObject.newInstance(ctx, element);
        }
        this.contributions.put(id, contrib);
        if (isDisabled) {
            String message = String.format("Usage of \"disabled\" attribute on RestBinding contribution '%s', in extension '%s', is deprecated: use \"enable\" attribute instead.", id, extensionId);
            DeprecationLogger.log((String)message, (String)"11.5");
            this.disabled.add(id);
        }
        if ((enable = xObject.getEnable()) != null && enable.hasValue(ctx, element)) {
            Object enabled = enable.getValue(ctx, element);
            if (enabled != null && Boolean.FALSE.equals(enabled)) {
                this.disabled.add(id);
            } else {
                this.disabled.remove(id);
            }
        }
        return (T)contrib;
    }
}

