/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server.jaxrs;

import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.ext.MessageBodyReader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.automation.jaxrs.JsonFactoryProvider;
import org.nuxeo.ecm.automation.jaxrs.io.operations.MultiPartFormRequestReader;
import org.nuxeo.ecm.automation.server.AutomationServer;
import org.nuxeo.ecm.automation.server.jaxrs.AutomationServerProvider;
import org.nuxeo.ecm.automation.server.jaxrs.AutomationServiceProvider;
import org.nuxeo.ecm.automation.server.jaxrs.CoreSessionProvider;
import org.nuxeo.ecm.webengine.app.WebEngineModule;
import org.nuxeo.ecm.webengine.jaxrs.coreiodelegate.CoreIODelegate;
import org.nuxeo.runtime.api.Framework;

public class AutomationModule
extends WebEngineModule {
    protected static final Logger log = LogManager.getLogger(AutomationModule.class);

    public Set<Class<?>> getClasses() {
        Set result = super.getClasses();
        result.add(MultiPartFormRequestReader.class);
        return result;
    }

    protected static Set<Object> setupSingletons() {
        HashSet<Object> result = new HashSet<Object>();
        AutomationServer as = (AutomationServer)Framework.getService(AutomationServer.class);
        for (Class<MessageBodyReader<?>> clazz : as.getReaders()) {
            try {
                result.add(clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (ReflectiveOperationException e) {
                log.error("Unable to instantiate MessageBodyReader: {}", clazz, (Object)e);
            }
        }
        for (Class<MessageBodyReader<?>> clazz : as.getWriters()) {
            try {
                result.add(clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (ReflectiveOperationException e) {
                log.error("Unable to instantiate MessageBodyWriter: {}", clazz, (Object)e);
            }
        }
        result.add(new AutomationServiceProvider());
        result.add(new AutomationServerProvider());
        result.add(new JsonFactoryProvider());
        result.add(new CoreSessionProvider());
        result.add(new CoreIODelegate());
        return result;
    }

    public Set<Object> getSingletons() {
        return AutomationModule.setupSingletons();
    }
}

