/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.xmap;

import java.util.Collections;
import java.util.Map;
import org.nuxeo.common.xmap.AttributeValueMapVisitor;
import org.nuxeo.common.xmap.Context;
import org.nuxeo.common.xmap.DOMHelper;
import org.nuxeo.common.xmap.ElementMapVisitor;
import org.nuxeo.common.xmap.ElementValueMapVisitor;
import org.nuxeo.common.xmap.Path;
import org.nuxeo.common.xmap.XAccessor;
import org.nuxeo.common.xmap.XAnnotatedList;
import org.nuxeo.common.xmap.XMLBuilder;
import org.nuxeo.common.xmap.XMap;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.w3c.dom.Element;

public class XAnnotatedMap
extends XAnnotatedList {
    protected static final ElementMapVisitor elementMapVisitor = new ElementMapVisitor();
    protected static final ElementValueMapVisitor elementVisitor = new ElementValueMapVisitor();
    protected static final AttributeValueMapVisitor attributeVisitor = new AttributeValueMapVisitor();
    protected final Path key;
    protected final boolean isNullByDefault;

    public XAnnotatedMap(XMap xmap, XAccessor setter, XNodeMap anno) {
        super(xmap, setter);
        this.path = new Path(anno.value());
        this.trim = anno.trim();
        this.key = new Path(anno.key());
        this.type = anno.type();
        this.componentType = anno.componentType();
        this.valueFactory = xmap.getValueFactory(this.componentType);
        this.xao = xmap.register(this.componentType);
        this.isNullByDefault = anno.nullByDefault();
    }

    @Override
    public void process(Context ctx, Element element, Object existing) {
        Object value;
        Map<String, ?> map;
        if (this.remove != null && Boolean.TRUE.equals(this.remove.getValue(ctx, element))) {
            this.setValue(ctx.getObject(), this.convertMap(Collections.emptyMap()));
            return;
        }
        Map<String, Object> initMap = this.getInitMap();
        if (existing != null && (!this.hasValue(ctx, element) || this.merge == null || Boolean.TRUE.equals(this.merge.getValue(ctx, element))) && (map = this.getCurrentMapValue(existing)) != null) {
            initMap.putAll(map);
        }
        if ((value = this.getValue(ctx, element, initMap)) != null) {
            this.setValue(ctx.getObject(), value);
        }
    }

    protected Map<String, Object> getInitMap() {
        try {
            return (Map)this.type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public Object getValue(Context ctx, Element base) {
        return this.getValue(ctx, base, this.getInitMap());
    }

    protected Object getValue(Context ctx, Element base, Map<String, Object> values) {
        if (this.xao != null) {
            DOMHelper.visitMapNodes(ctx, this, base, this.path, elementMapVisitor, values);
        } else if (this.path.attribute != null) {
            DOMHelper.visitMapNodes(ctx, this, base, this.path, attributeVisitor, values);
        } else {
            DOMHelper.visitMapNodes(ctx, this, base, this.path, elementVisitor, values);
        }
        return this.convertMap(values);
    }

    protected Object convertMap(Map<String, Object> values) {
        if (this.isNullByDefault && values.isEmpty()) {
            values = null;
        }
        return values;
    }

    protected Map<String, ?> getCurrentMapValue(Object instance) {
        Object v = this.accessor.getValue(instance);
        if (v instanceof Map) {
            return (Map)v;
        }
        return null;
    }

    @Override
    public void toXML(Object instance, Element parent) {
        Map<String, ?> map = this.getCurrentMapValue(instance);
        if (map == null) {
            return;
        }
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            String entryKey = entry.getKey();
            Element e = XMLBuilder.addElement(parent, this.path);
            Element keyElement = XMLBuilder.getOrCreateElement(e, this.key);
            XMLBuilder.fillField(keyElement, entryKey, this.key.attribute);
            if (this.xao == null) {
                String value = this.valueFactory.serialize(null, entry.getValue());
                XMLBuilder.fillField(e, value, null);
                continue;
            }
            XMLBuilder.fillField(keyElement, entryKey, this.key.attribute);
            XMLBuilder.toXML(entry.getValue(), e, this.xao);
        }
    }
}

