/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.xmap;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.time.Duration;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.common.utils.DurationUtils;
import org.nuxeo.common.xmap.Context;
import org.nuxeo.common.xmap.Resource;
import org.nuxeo.common.xmap.XMapException;
import org.w3c.dom.Node;

public abstract class XValueFactory {
    static final Map<Class<?>, XValueFactory> defaultFactories = new Hashtable();
    public static final XValueFactory STRING = new XValueFactory(){

        @Override
        public Object deserialize(Context context, String value) {
            return value;
        }

        @Override
        public String serialize(Context context, Object value) {
            return value.toString();
        }
    };
    public static final XValueFactory INTEGER = new XValueFactory(){

        @Override
        public Object deserialize(Context context, String value) {
            return Integer.valueOf(value);
        }

        @Override
        public String serialize(Context context, Object value) {
            return value.toString();
        }
    };
    public static final XValueFactory LONG = new XValueFactory(){

        @Override
        public Object deserialize(Context context, String value) {
            return Long.valueOf(value);
        }

        @Override
        public String serialize(Context context, Object value) {
            return value.toString();
        }
    };
    public static final XValueFactory DOUBLE = new XValueFactory(){

        @Override
        public Object deserialize(Context context, String value) {
            return Double.valueOf(value);
        }

        @Override
        public String serialize(Context context, Object value) {
            return value.toString();
        }
    };
    public static final XValueFactory FLOAT = new XValueFactory(){

        @Override
        public Object deserialize(Context context, String value) {
            return Float.valueOf(value);
        }

        @Override
        public String serialize(Context context, Object value) {
            return value.toString();
        }
    };
    public static final XValueFactory BOOLEAN = new XValueFactory(){

        @Override
        public Object deserialize(Context context, String value) {
            return Boolean.valueOf(value);
        }

        @Override
        public String serialize(Context context, Object value) {
            return value.toString();
        }
    };
    public static final XValueFactory DATE = new XValueFactory(){
        private final DateFormat df = DateFormat.getDateInstance();

        @Override
        public Object deserialize(Context context, String value) {
            try {
                return this.df.parse(value);
            }
            catch (ParseException e) {
                return null;
            }
        }

        @Override
        public String serialize(Context context, Object value) {
            Date date = (Date)value;
            return this.df.format(date);
        }
    };
    public static final XValueFactory FILE = new XValueFactory(){

        @Override
        public Object deserialize(Context context, String value) {
            return new File(value);
        }

        @Override
        public String serialize(Context context, Object value) {
            File file = (File)value;
            return file.getName();
        }
    };
    public static final XValueFactory URL = new XValueFactory(){

        @Override
        public Object deserialize(Context context, String value) {
            try {
                return new URL(value);
            }
            catch (MalformedURLException e) {
                return null;
            }
        }

        @Override
        public String serialize(Context context, Object value) {
            return value.toString();
        }
    };
    public static final XValueFactory CLASS = new XValueFactory(){

        @Override
        public Object deserialize(Context context, String value) {
            if (StringUtils.isBlank(value)) {
                return null;
            }
            try {
                return context.loadClass(value);
            }
            catch (ClassNotFoundException e) {
                throw new XMapException("Cannot load class: " + value, e);
            }
        }

        @Override
        public String serialize(Context context, Object value) {
            Class clazz = (Class)value;
            return clazz.getName();
        }
    };
    public static final XValueFactory RESOURCE = new XValueFactory(){

        @Override
        public Object deserialize(Context context, String value) {
            return new Resource(context.getResource(value));
        }

        @Override
        public String serialize(Context context, Object value) {
            return value.toString();
        }
    };
    public static final XValueFactory DURATION = new XValueFactory(){

        @Override
        public Object deserialize(Context context, String value) {
            return DurationUtils.parse(value);
        }

        @Override
        public String serialize(Context context, Object value) {
            return value.toString();
        }
    };

    public abstract Object deserialize(Context var1, String var2);

    public abstract String serialize(Context var1, Object var2);

    public final Object getElementValue(Context context, Node element, boolean trim) {
        String text = element.getTextContent();
        return this.deserialize(context, trim ? text.trim() : text);
    }

    public final Object getAttributeValue(Context context, Node element, String name) {
        Node at = element.getAttributes().getNamedItem(name);
        return at != null ? this.deserialize(context, at.getNodeValue()) : null;
    }

    public static void addFactory(Class<?> klass, XValueFactory factory) {
        defaultFactories.put(klass, factory);
    }

    public static XValueFactory getFactory(Class<?> type) {
        return defaultFactories.get(type);
    }

    public static Object getValue(Context context, Class<?> klass, String value) {
        XValueFactory factory = defaultFactories.get(klass);
        if (factory == null) {
            return null;
        }
        return factory.deserialize(context, value);
    }

    static {
        XValueFactory.addFactory(String.class, STRING);
        XValueFactory.addFactory(Integer.class, INTEGER);
        XValueFactory.addFactory(Long.class, LONG);
        XValueFactory.addFactory(Double.class, DOUBLE);
        XValueFactory.addFactory(Date.class, DATE);
        XValueFactory.addFactory(Boolean.class, BOOLEAN);
        XValueFactory.addFactory(File.class, FILE);
        XValueFactory.addFactory(URL.class, URL);
        XValueFactory.addFactory(Integer.TYPE, INTEGER);
        XValueFactory.addFactory(Long.TYPE, LONG);
        XValueFactory.addFactory(Double.TYPE, DOUBLE);
        XValueFactory.addFactory(Float.TYPE, FLOAT);
        XValueFactory.addFactory(Boolean.TYPE, BOOLEAN);
        XValueFactory.addFactory(Class.class, CLASS);
        XValueFactory.addFactory(Resource.class, RESOURCE);
        XValueFactory.addFactory(Duration.class, DURATION);
    }
}

