/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.downloads;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.nuxeo.connect.HttpClientBuilderHelper;
import org.nuxeo.connect.NuxeoConnectClient;
import org.nuxeo.connect.connector.ConnectServerError;
import org.nuxeo.connect.connector.http.ConnectUrlConfig;
import org.nuxeo.connect.data.DownloadingPackage;
import org.nuxeo.connect.data.PackageDescriptor;
import org.nuxeo.connect.downloads.ConnectDownloadManager;
import org.nuxeo.connect.identity.SecurityHeaderGenerator;
import org.nuxeo.connect.update.AlreadyExistsPackageException;
import org.nuxeo.connect.update.PackageException;
import org.nuxeo.connect.update.PackageState;
import org.nuxeo.connect.update.PackageUpdateService;

public class LocalDownloadingPackage
extends PackageDescriptor
implements DownloadingPackage,
Runnable {
    public static final int CONNECTION_TIMEOUT_MS = 30000;
    public static final int SO_TIMEOUT_MS = 120000;
    protected static final Log log = LogFactory.getLog(LocalDownloadingPackage.class);
    protected File file = null;
    private boolean completed = false;
    private boolean serverError = false;

    public LocalDownloadingPackage(PackageDescriptor descriptor) {
        super(descriptor);
        this.sourceUrl = ConnectUrlConfig.getDownloadBaseUrl() + descriptor.getSourceUrl();
        this.sourceDigest = descriptor.getSourceDigest();
        this.sourceSize = descriptor.getSourceSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveStreamAsFile(InputStream in) throws IOException {
        ConnectDownloadManager cdm = NuxeoConnectClient.getDownloadManager();
        String path = cdm.getDownloadedBundleLocalStorage();
        this.file = new File(path, this.getId());
        try (FileOutputStream out = null;){
            int read;
            out = new FileOutputStream(this.file);
            byte[] buffer = new byte[1024];
            while ((read = in.read(buffer)) != -1) {
                ((OutputStream)out).write(buffer, 0, read);
            }
        }
    }

    @Override
    public int getDownloadProgress() {
        if (this.file == null || !this.file.exists()) {
            return 0;
        }
        if (this.getSourceSize() == 0L) {
            return 0;
        }
        return (int)(this.file.length() * 100L / this.getSourceSize());
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public boolean isDigestOk() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        this.setPackageState(PackageState.REMOTE);
        HttpClientBuilder httpClientBuilder = HttpClientBuilderHelper.getHttpClientBuilder(120000, 30000, this.sourceUrl);
        try (CloseableHttpClient httpClient = httpClientBuilder.build();){
            this.setPackageState(PackageState.DOWNLOADING);
            HttpGet method = new HttpGet(this.sourceUrl);
            if (!this.sourceUrl.contains(ConnectUrlConfig.getBaseUrl() + "test")) {
                Map<String, String> headers = SecurityHeaderGenerator.getHeaders();
                for (String headerName : headers.keySet()) {
                    method.addHeader(headerName, headers.get(headerName));
                }
            }
            CloseableHttpResponse httpResponse = httpClient.execute(method);
            Object object = null;
            try {
                int rc = httpResponse.getStatusLine().getStatusCode();
                switch (rc) {
                    case 200: {
                        Header clheader;
                        if (this.sourceSize == 0L && (clheader = httpResponse.getFirstHeader("content-length")) != null) {
                            this.sourceSize = Long.parseLong(clheader.getValue());
                        }
                        InputStream in = httpResponse.getEntity().getContent();
                        this.saveStreamAsFile(in);
                        this.registerDownloadedPackage();
                        this.setPackageState(PackageState.DOWNLOADED);
                        return;
                    }
                    case 404: {
                        throw new ConnectServerError(String.format("Package not found (%s).", rc));
                    }
                    case 403: {
                        throw new ConnectServerError(String.format("Access refused (%s).", rc));
                    }
                    case 401: {
                        throw new ConnectServerError(String.format("Registration required (%s).", rc));
                    }
                    default: {
                        this.serverError = true;
                        throw new ConnectServerError(String.format("Connect server HTTP response code %s.", rc));
                    }
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (httpResponse != null) {
                    if (object != null) {
                        try {
                            httpResponse.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        httpResponse.close();
                    }
                }
            }
        }
        catch (IOException e) {
            this.serverError = true;
            this.setPackageState(PackageState.REMOTE);
            log.debug(e, e);
            this.errorMessage = e.getMessage();
            return;
        }
        catch (ConnectServerError e) {
            this.setPackageState(PackageState.REMOTE);
            log.debug(e, e);
            this.errorMessage = e.getMessage();
            return;
        }
        finally {
            ConnectDownloadManager cdm = NuxeoConnectClient.getDownloadManager();
            cdm.removeDownloadingPackage(this.getId());
            this.completed = true;
        }
    }

    protected void registerDownloadedPackage() {
        PackageUpdateService pus = NuxeoConnectClient.getPackageUpdateService();
        try {
            pus.addPackage(this.file);
            log.info("Added " + this.getId());
        }
        catch (AlreadyExistsPackageException e) {
            log.error(e.getMessage());
        }
        catch (PackageException e) {
            log.error(e);
        }
    }

    @Override
    public boolean isCompleted() {
        return this.completed;
    }

    @Override
    public boolean isServerError() {
        return this.serverError;
    }
}

