/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.launcher.info;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.common.codec.Crypto;
import org.nuxeo.connect.update.LocalPackage;
import org.nuxeo.launcher.config.ConfigurationConstants;
import org.nuxeo.launcher.config.ConfigurationHolder;
import org.nuxeo.launcher.info.ConfigurationInfo;
import org.nuxeo.launcher.info.DistributionInfo;
import org.nuxeo.launcher.info.KeyValueInfo;
import org.nuxeo.launcher.info.PackageInfo;

@XmlAccessorType(value=XmlAccessType.NONE)
@XmlRootElement(name="instance")
public class InstanceInfo {
    protected static final List<String> SECRET_KEYS = Arrays.asList("mailservice.password", "mail.transport.password", "nuxeo.http.proxy.password", "nuxeo.ldap.bindpassword", "nuxeo.user.emergency.password");
    @XmlElement(name="NUXEO_CONF")
    public String NUXEO_CONF;
    @XmlElement(name="NUXEO_HOME")
    public String NUXEO_HOME;
    @XmlElement(name="clid")
    public String clid;
    @XmlElement(name="distribution")
    public DistributionInfo distribution;
    @XmlElementWrapper(name="packages")
    @XmlElement(name="package")
    public List<PackageInfo> packages = new ArrayList<PackageInfo>();
    @XmlElement(name="configuration")
    public ConfigurationInfo config;

    public static InstanceInfo from(ConfigurationHolder configHolder, String clid, List<LocalPackage> pkgs) {
        InstanceInfo nxInstance = new InstanceInfo();
        nxInstance.NUXEO_CONF = configHolder.getNuxeoConfPath().toString();
        nxInstance.NUXEO_HOME = configHolder.getHomePath().toString();
        Path distFile = configHolder.getConfigurationPath().resolve("distribution.properties");
        if (Files.notExists(distFile, new LinkOption[0])) {
            distFile = configHolder.getTemplatesPath().resolve(ConfigurationConstants.FILE_TEMPLATE_DISTRIBUTION_PROPS);
        }
        try {
            nxInstance.distribution = new DistributionInfo(distFile.toFile());
        }
        catch (IOException e) {
            nxInstance.distribution = new DistributionInfo();
        }
        nxInstance.clid = clid;
        HashSet<String> pkgTemplates = new HashSet<String>();
        for (LocalPackage pkg : pkgs) {
            PackageInfo info = new PackageInfo(pkg);
            nxInstance.packages.add(info);
            pkgTemplates.addAll(info.templates);
        }
        nxInstance.config = new ConfigurationInfo();
        String profiles = System.getenv("NUXEO_PROFILES");
        if (StringUtils.isNotBlank(profiles)) {
            nxInstance.config.profiles.addAll(Arrays.asList(profiles.split(",")));
        }
        nxInstance.config.dbtemplate = configHolder.getIncludedDBTemplateName();
        List<String> userTemplates = configHolder.getIncludedTemplateNames();
        for (String template : userTemplates) {
            if (template.equals(nxInstance.config.dbtemplate)) continue;
            if (pkgTemplates.contains(template)) {
                nxInstance.config.pkgtemplates.add(template);
                continue;
            }
            if (Files.exists(configHolder.getTemplatesPath().resolve(template), new LinkOption[0])) {
                nxInstance.config.basetemplates.add(template);
                continue;
            }
            nxInstance.config.usertemplates.add(template);
        }
        nxInstance.config.keyvals = InstanceInfo.computeKeyVals(configHolder, configHolder.keySet());
        nxInstance.config.allkeyvals = InstanceInfo.computeKeyVals(configHolder, configHolder.stringPropertyNames());
        return nxInstance;
    }

    protected static List<KeyValueInfo> computeKeyVals(ConfigurationHolder configHolder, Set<String> keys) {
        ArrayList<KeyValueInfo> keyVals = new ArrayList<KeyValueInfo>(keys.size());
        for (String key : new TreeSet<String>(keys)) {
            String value = configHolder.getRawProperty(key);
            if (SECRET_KEYS.contains(key) || key.contains("password") || key.equals("server.status.key") || Crypto.isEncrypted(value)) {
                value = "********";
            }
            keyVals.add(new KeyValueInfo(key, value));
        }
        return keyVals;
    }
}

