/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.launcher.process;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.nuxeo.launcher.process.ProcessManager;

public class UnixProcessManager
extends ProcessManager {
    private static final Pattern PS_OUTPUT_LINE = Pattern.compile("^\\s*(\\d+)\\s+(.*)$");

    protected UnixProcessManager(Pattern processPattern) {
        super(processPattern);
    }

    protected String[] psCommand() {
        return new String[]{"/bin/ps", "-e", "-o", "pid,args"};
    }

    @Override
    public Optional<Long> findPid() throws IOException {
        for (String line : this.execute0(this.psCommand())) {
            String command;
            Matcher commandMatcher;
            Matcher lineMatcher = this.lineMatcher(line);
            if (!lineMatcher.matches() || !(commandMatcher = this.processPattern.matcher(command = lineMatcher.group(2))).find()) continue;
            return Optional.ofNullable(lineMatcher.group(1)).map(Long::valueOf);
        }
        return super.findPid();
    }

    protected Matcher lineMatcher(String line) {
        return PS_OUTPUT_LINE.matcher(line);
    }

    @Override
    public void kill(ProcessHandle processHandle) throws IOException {
        this.execute0("/bin/kill", "-KILL", String.valueOf(processHandle.pid()));
    }

    protected List<String> execute0(String ... command) throws IOException {
        return UnixProcessManager.execute(command);
    }

    protected static List<String> execute(String ... command) throws IOException {
        Process process = new ProcessBuilder(command).start();
        return IOUtils.readLines(process.getInputStream(), StandardCharsets.UTF_8);
    }
}

