/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.tools;

import java.math.BigInteger;
import java.util.Iterator;
import org.sat4j.core.ConstrGroup;
import org.sat4j.core.VecInt;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.ObjectiveFunction;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.tools.xplain.Xplain;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XplainPB
extends Xplain<IPBSolver>
implements IPBSolver {
    private static final long serialVersionUID = 1L;

    public XplainPB(IPBSolver solver) {
        super(solver);
    }

    @Override
    public IConstr addAtLeast(IVecInt literals, int degree) throws ContradictionException {
        VecInt coeffs = new VecInt(literals.size(), 1);
        int newvar = this.createNewVar(literals);
        literals.push(newvar);
        coeffs.push(coeffs.size() - degree);
        IConstr constr = ((IPBSolver)this.decorated()).addAtLeast(literals, coeffs, degree);
        if (constr == null) {
            this.discardLastestVar();
        } else {
            this.constrs.put(new Integer(newvar), constr);
        }
        return constr;
    }

    @Override
    public IConstr addAtMost(IVecInt literals, int degree) throws ContradictionException {
        VecInt coeffs = new VecInt(literals.size(), 1);
        int newvar = this.createNewVar(literals);
        literals.push(newvar);
        coeffs.push(degree - coeffs.size());
        IConstr constr = ((IPBSolver)this.decorated()).addAtMost(literals, coeffs, degree);
        if (constr == null) {
            this.discardLastestVar();
        } else {
            this.constrs.put(new Integer(newvar), constr);
        }
        return constr;
    }

    @Override
    public IConstr addExactly(IVecInt literals, int n) throws ContradictionException {
        int newvar = this.createNewVar(literals);
        VecInt coeffs = new VecInt(literals.size(), 1);
        literals.push(newvar);
        coeffs.push(n - coeffs.size());
        IConstr constr1 = ((IPBSolver)this.decorated()).addAtMost(literals, coeffs, n);
        coeffs.pop();
        coeffs.push(coeffs.size() - n);
        IConstr constr2 = ((IPBSolver)this.decorated()).addAtLeast(literals, coeffs, n);
        if (constr1 == null && constr2 == null) {
            this.discardLastestVar();
            return null;
        }
        ConstrGroup group = new ConstrGroup();
        group.add(constr1);
        group.add(constr2);
        this.constrs.put(new Integer(newvar), group);
        return group;
    }

    @Override
    public IConstr addPseudoBoolean(IVecInt lits, IVec<BigInteger> coeffs, boolean moreThan, BigInteger d) throws ContradictionException {
        int newvar = this.createNewVar(lits);
        lits.push(newvar);
        if (moreThan && d.signum() >= 0) {
            coeffs.push(d);
        } else {
            BigInteger sum = BigInteger.ZERO;
            Iterator<BigInteger> ite = coeffs.iterator();
            while (ite.hasNext()) {
                sum = sum.add(ite.next());
            }
            sum = sum.subtract(d);
            coeffs.push(sum.negate());
        }
        IConstr constr = ((IPBSolver)this.decorated()).addPseudoBoolean(lits, coeffs, moreThan, d);
        if (constr == null) {
            this.discardLastestVar();
        } else {
            this.constrs.put(new Integer(newvar), constr);
        }
        return constr;
    }

    @Override
    public void setObjectiveFunction(ObjectiveFunction obj) {
        ((IPBSolver)this.decorated()).setObjectiveFunction(obj);
    }

    @Override
    public ObjectiveFunction getObjectiveFunction() {
        return ((IPBSolver)this.decorated()).getObjectiveFunction();
    }

    @Override
    public IConstr addAtMost(IVecInt literals, IVecInt coeffs, int degree) throws ContradictionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IConstr addAtMost(IVecInt literals, IVec<BigInteger> coeffs, BigInteger degree) throws ContradictionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IConstr addAtLeast(IVecInt literals, IVecInt coeffs, int degree) throws ContradictionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IConstr addAtLeast(IVecInt literals, IVec<BigInteger> coeffs, BigInteger degree) throws ContradictionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IConstr addExactly(IVecInt literals, IVecInt coeffs, int weight) throws ContradictionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IConstr addExactly(IVecInt literals, IVec<BigInteger> coeffs, BigInteger weight) throws ContradictionException {
        throw new UnsupportedOperationException();
    }
}

