/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.app;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.ws.rs.core.MediaType;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.webengine.JsonFactoryManager;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.runtime.api.Framework;

public class JsonWebengineWriter {
    static JsonFactoryManager jsonFactoryManager;

    private static JsonFactory getFactory() {
        jsonFactoryManager = (JsonFactoryManager)Framework.getService(JsonFactoryManager.class);
        return jsonFactoryManager.getJsonFactory();
    }

    private static JsonGenerator createGenerator(OutputStream out) throws IOException {
        return JsonWebengineWriter.getFactory().createJsonGenerator(out, JsonEncoding.UTF8);
    }

    @Deprecated
    public static void writeException(OutputStream out, WebException webException, MediaType mediaType) throws IOException {
        JsonWebengineWriter.writeException(JsonWebengineWriter.createGenerator(out), webException, mediaType);
    }

    @Deprecated
    public static void writeException(JsonGenerator jg, WebException webException, MediaType mediaType) throws IOException {
        JsonWebengineWriter.writeException(jg, (Throwable)((Object)webException), mediaType, webException.getStatus());
    }

    public static void writeException(OutputStream out, NuxeoException nuxeoException, MediaType mediaType) throws IOException {
        JsonWebengineWriter.writeException(JsonWebengineWriter.createGenerator(out), nuxeoException, mediaType);
    }

    public static void writeException(JsonGenerator jg, NuxeoException nuxeoException, MediaType mediaType) throws IOException {
        JsonWebengineWriter.writeException(jg, nuxeoException, mediaType, nuxeoException.getStatusCode());
    }

    protected static void writeException(JsonGenerator jg, Throwable t, MediaType mediaType, int statusCode) throws IOException {
        jg.writeStartObject();
        jg.writeStringField("entity-type", "exception");
        jg.writeNumberField("status", statusCode);
        jg.writeStringField("message", JsonWebengineWriter.getExceptionMessage(t.getMessage(), statusCode));
        if (jsonFactoryManager.isStackDisplay()) {
            jg.writeStringField("stacktrace", JsonWebengineWriter.getStackTraceString(t));
            jg.writeObjectField("exception", (Object)t);
        }
        jg.writeEndObject();
        jg.flush();
    }

    protected static String getExceptionMessage(String exceptionMessage, int statusCode) {
        if (statusCode < 500 || jsonFactoryManager.isStackDisplay() || Framework.isDevModeSet()) {
            return exceptionMessage;
        }
        return "Internal Server Error";
    }

    protected static String getStackTraceString(Throwable t) throws IOException {
        try (StringWriter sw = new StringWriter();){
            PrintWriter pw = new PrintWriter(sw);
            try {
                t.printStackTrace(pw);
                String string = sw.toString();
                pw.close();
                return string;
            }
            catch (Throwable throwable) {
                try {
                    pw.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }
}

