/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.contribution.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.runtime.contribution.Contribution;
import org.nuxeo.runtime.contribution.ContributionRegistry;
import org.nuxeo.runtime.contribution.impl.ContributionImpl;

public abstract class AbstractContributionRegistry<K, T>
implements ContributionRegistry<K, T> {
    protected final Map<Object, Contribution<K, T>> registry = new HashMap<Object, Contribution<K, T>>();
    protected final AbstractContributionRegistry<K, T> parent;
    protected final List<AbstractContributionRegistry<K, T>> listeners;

    protected AbstractContributionRegistry() {
        this(null);
    }

    protected AbstractContributionRegistry(AbstractContributionRegistry<K, T> parent) {
        this.parent = parent;
        this.listeners = new ArrayList<AbstractContributionRegistry<K, T>>();
    }

    @Override
    public ContributionRegistry<K, T> getParent() {
        return this.parent;
    }

    protected synchronized void importParentContributions() {
        AbstractContributionRegistry<K, T> pParent = this.parent;
        ArrayList<AbstractContributionRegistry<K, T>> parents = new ArrayList<AbstractContributionRegistry<K, T>>();
        while (pParent != null) {
            parents.add(pParent);
            pParent = pParent.parent;
        }
        Collections.reverse(parents);
        for (AbstractContributionRegistry<K, T> p : parents) {
            p.listeners.add(this);
            for (Contribution contrib : p.registry.values().toArray(new Contribution[0])) {
                this.importContribution(contrib);
            }
            p = p.parent;
        }
    }

    protected void importContribution(Contribution<K, T> contrib) {
        if (!contrib.isResolved()) {
            return;
        }
        for (Contribution<K, T> dep : contrib.getDependencies()) {
            this.importContribution(dep);
        }
        this.installContribution(contrib.getId(), contrib.getValue());
    }

    @Override
    public synchronized Contribution<K, T> getContribution(K primaryKey) {
        Contribution<K, T> contrib = this.registry.get(primaryKey);
        if (contrib == null && this.parent != null) {
            contrib = this.parent.getContribution(primaryKey);
        }
        return contrib;
    }

    public T getObject(K key) {
        Contribution<K, T> contrib = this.getContribution(key);
        if (contrib != null && contrib.isResolved()) {
            return contrib.getValue();
        }
        return null;
    }

    @Override
    public synchronized void removeContribution(K key) {
        Contribution<K, T> contrib = this.registry.get(key);
        if (contrib != null) {
            contrib.unregister();
        }
    }

    @Override
    public void removeFragment(K key, T fragment) {
        Contribution<K, T> contrib = this.registry.get(key);
        if (contrib != null) {
            contrib.removeFragment(fragment);
        }
    }

    @Override
    public synchronized Contribution<K, T> addFragment(K key, T fragment, K ... superKeys) {
        Contribution<K, T> contrib = this.registry.get(key);
        if (contrib == null) {
            contrib = new ContributionImpl(this, key);
            this.registry.put(key, contrib);
        }
        contrib.addFragment(fragment, superKeys);
        return contrib;
    }

    public synchronized Contribution<K, T> getOrCreateDependency(K key) {
        Contribution<K, T> contrib = this.getContribution(key);
        if (contrib == null) {
            contrib = new ContributionImpl(this, key);
            this.registry.put(key, contrib);
        }
        return contrib;
    }

    public void fireUnresolved(Contribution<K, T> contrib, T value) {
        K key = contrib.getId();
        this.uninstallContribution(key, value);
        if (!this.listeners.isEmpty()) {
            for (AbstractContributionRegistry<K, T> reg : this.listeners) {
                reg.uninstallContribution(key, value);
            }
        }
    }

    public void fireResolved(Contribution<K, T> contrib) {
        K key = contrib.getId();
        T value = contrib.getValue();
        if (value == null) {
            throw new IllegalStateException("contribution is null");
        }
        this.installContribution(key, value);
        if (!this.listeners.isEmpty()) {
            for (AbstractContributionRegistry<K, T> reg : this.listeners) {
                reg.installContribution(key, value);
            }
        }
    }

    public void fireUpdated(T oldValue, Contribution<K, T> contrib) {
        T value = contrib.getValue();
        if (value == null) {
            throw new IllegalStateException("contribution is null");
        }
        this.updateContribution(contrib.getId(), value, oldValue);
    }

    @Override
    public void dispose() {
        this.registry.clear();
    }

    protected abstract T clone(T var1);

    protected void applyFragment(T object, T fragment) {
    }

    protected void applySuperFragment(T object, T superFragment) {
    }

    protected abstract void installContribution(K var1, T var2);

    protected abstract void uninstallContribution(K var1, T var2);

    protected boolean isMainFragment(T object) {
        return true;
    }

    protected void updateContribution(K key, T object, T oldValue) {
        this.uninstallContribution(key, oldValue);
        this.installContribution(key, object);
    }
}

