/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.management.standby;

import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import org.nuxeo.ecm.core.management.standby.StandbyMXBean;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.management.ObjectNameFactory;
import org.nuxeo.runtime.model.ComponentManager;

public class StandbyCommand
implements StandbyMXBean {
    protected final Registration registration = new Registration();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void standby(int delay) throws InterruptedException {
        ComponentManager mgr = Framework.getRuntime().getComponentManager();
        if (mgr.isStandby()) {
            return;
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(Framework.class.getClassLoader());
        try {
            mgr.standby(delay);
        }
        finally {
            Thread.currentThread().setContextClassLoader(loader);
        }
    }

    @Override
    public void resume() {
        ComponentManager mgr = Framework.getRuntime().getComponentManager();
        if (!mgr.isStandby()) {
            return;
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(Framework.class.getClassLoader());
        try {
            mgr.resume();
        }
        finally {
            Thread.currentThread().setContextClassLoader(loader);
        }
    }

    @Override
    public boolean isStandby() {
        return Framework.getRuntime().getComponentManager().isStandby();
    }

    protected class Registration {
        protected MBeanServer server;
        protected ObjectInstance instance;

        protected Registration() {
        }

        protected Registration with(MBeanServer server) {
            this.server = server;
            return this;
        }

        protected Registration register() throws JMException {
            this.instance = this.server.registerMBean(StandbyCommand.this, ObjectNameFactory.getObjectName((String)StandbyCommand.class.getName()));
            return this;
        }

        protected void unregister() throws JMException {
            try {
                this.server.unregisterMBean(this.instance.getObjectName());
            }
            finally {
                this.instance = null;
            }
        }
    }
}

