/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.notification;

import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.DocumentLocationImpl;
import org.nuxeo.ecm.platform.ec.notification.service.NotificationService;
import org.nuxeo.ecm.platform.ec.notification.service.NotificationServiceHelper;
import org.nuxeo.ecm.platform.url.DocumentViewImpl;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.ecm.platform.url.api.DocumentViewCodecManager;
import org.nuxeo.ecm.platform.url.codec.api.DocumentViewCodec;
import org.nuxeo.runtime.api.Framework;

public class MailTemplateHelper {
    protected static final Log log = LogFactory.getLog(MailTemplateHelper.class);

    private MailTemplateHelper() {
    }

    public static String getDocumentUrl(DocumentModel doc, String viewId) {
        NotificationService notificationService = NotificationServiceHelper.getNotificationService();
        DocumentViewCodecManager codecService = (DocumentViewCodecManager)Framework.getService(DocumentViewCodecManager.class);
        DocumentViewCodec codec = codecService.getCodec("notificationDocId");
        boolean isNotificationCodec = codec != null;
        String result = "";
        if (isNotificationCodec) {
            DocumentViewImpl view = viewId == null ? new DocumentViewImpl(doc) : new DocumentViewImpl((DocumentLocation)new DocumentLocationImpl(doc), viewId);
            result = codecService.getUrlFromDocumentView("notificationDocId", (DocumentView)view, true, notificationService.getServerUrlPrefix());
        } else {
            log.warn((Object)"No codec was found to notify document url. It is like that no UI is installed.");
        }
        return result;
    }

    public static URL getTemplate(String name) {
        return NotificationServiceHelper.getNotificationService().getTemplateURL(name);
    }
}

