/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.features;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.text.StringEscapeUtils;
import org.nuxeo.ecm.automation.core.scripting.CoreFunctions;
import org.nuxeo.ecm.automation.core.util.StringList;
import org.nuxeo.ecm.automation.features.PrincipalHelper;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.query.sql.NXQL;
import org.nuxeo.ecm.core.uidgen.UIDGeneratorService;
import org.nuxeo.ecm.core.uidgen.UIDSequencer;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.config.ConfigurationService;

public class PlatformFunctions
extends CoreFunctions {
    private static final Log log = LogFactory.getLog(PlatformFunctions.class);
    public static final String HIBERNATE_SEQUENCER_PROPERTY = "org.nuxeo.ecm.core.uidgen.sequencer.hibernate";

    public UserManager getUserManager() {
        return (UserManager)Framework.getService(UserManager.class);
    }

    @Deprecated
    public DirectoryService getDirService() {
        return (DirectoryService)Framework.getService(DirectoryService.class);
    }

    public String getVocabularyLabel(String voc, String key) {
        DirectoryService directoryService = (DirectoryService)Framework.getService(DirectoryService.class);
        try (Session session = directoryService.open(voc);){
            if (!session.hasEntry(key)) {
                log.debug((Object)("Unable to find the key '" + key + "' in the vocabulary '" + voc + "'."));
                String string = key;
                return string;
            }
            DocumentModel doc = session.getEntry(key);
            String string = (String)((Object)doc.getPropertyValue("label"));
            return string;
        }
    }

    public NuxeoPrincipal getPrincipal(String username) {
        return this.getUserManager().getPrincipal(username);
    }

    protected String getEmail(NuxeoPrincipal principal, String userSchemaName, String userEmailFieldName) {
        if (principal == null) {
            return null;
        }
        return (String)principal.getModel().getProperty(userSchemaName, userEmailFieldName);
    }

    public String getEmail(String username) {
        UserManager userManager = this.getUserManager();
        return this.getEmail(userManager.getPrincipal(username), userManager.getUserSchemaName(), userManager.getUserEmailField());
    }

    public Set<NuxeoPrincipal> getPrincipalsFromGroup(String group) {
        return this.getPrincipalsFromGroup(group, false);
    }

    public Set<NuxeoPrincipal> getPrincipalsFromGroup(String group, boolean ignoreGroups) {
        PrincipalHelper ph = new PrincipalHelper(this.getUserManager(), null);
        return ph.getPrincipalsFromGroup(group, !ignoreGroups);
    }

    public StringList getEmailsFromGroup(String group) {
        return this.getEmailsFromGroup(group, false);
    }

    public StringList getEmailsFromGroup(String group, boolean ignoreGroups) {
        PrincipalHelper ph = new PrincipalHelper(this.getUserManager(), null);
        Set<String> emails = ph.getEmailsFromGroup(group, !ignoreGroups);
        return new StringList(emails);
    }

    public StringList getPrincipalEmails(List<NuxeoPrincipal> principals) {
        StringList result = new StringList(principals.size());
        String schemaName = this.getUserManager().getUserSchemaName();
        String fieldName = this.getUserManager().getUserEmailField();
        for (NuxeoPrincipal principal : principals) {
            String email = this.getEmail(principal, schemaName, fieldName);
            if (StringUtils.isEmpty((CharSequence)email)) continue;
            result.add((Object)email);
        }
        return result;
    }

    public StringList getEmails(List<String> usernames) {
        return this.getEmails(usernames, false);
    }

    public StringList getEmails(List<String> usernames, boolean usePrefix) {
        if (usernames == null) {
            return new StringList(0);
        }
        UserManager userManager = this.getUserManager();
        StringList result = new StringList(usernames.size());
        String schemaName = this.getUserManager().getUserSchemaName();
        String fieldName = this.getUserManager().getUserEmailField();
        for (String username : usernames) {
            String email;
            NuxeoPrincipal principal = null;
            if (usePrefix) {
                if (username.startsWith("user:")) {
                    principal = userManager.getPrincipal(username.replace("user:", ""));
                }
            } else {
                principal = userManager.getPrincipal(username);
            }
            if (principal == null || StringUtils.isEmpty((CharSequence)(email = this.getEmail(principal, schemaName, fieldName)))) continue;
            result.add((Object)email);
        }
        return result;
    }

    public String getNextId(String key) {
        ConfigurationService configurationService = (ConfigurationService)Framework.getService(ConfigurationService.class);
        boolean useHibernate = configurationService.isBooleanTrue(HIBERNATE_SEQUENCER_PROPERTY);
        return this.getNextId(key, useHibernate ? "hibernateSequencer" : null);
    }

    public String getNextId(String key, String sequencerName) {
        UIDGeneratorService uidGeneratorService = (UIDGeneratorService)Framework.getService(UIDGeneratorService.class);
        UIDSequencer seq = uidGeneratorService.getSequencer(sequencerName);
        return Long.toString(seq.getNextLong(key));
    }

    public String htmlEscape(String str) {
        return StringEscapeUtils.escapeHtml4((String)str);
    }

    public String nxqlEscape(String str) {
        return NXQL.escapeStringInner((String)str);
    }

    public <T> List<T> concatenateIntoList(List<T> list, Object ... values) {
        if (list == null) {
            throw new IllegalArgumentException("First parameter must not be null");
        }
        for (Object value : values) {
            if (value == null) continue;
            if (value instanceof Object[]) {
                for (Object subValue : (Object[])value) {
                    if (subValue == null) continue;
                    list.add(subValue);
                }
                continue;
            }
            if (value instanceof Collection) {
                for (Object subValue : (Collection)value) {
                    if (subValue == null) continue;
                    list.add(subValue);
                }
                continue;
            }
            list.add(value);
        }
        return list;
    }

    public <T> List<T> concatenateValuesAsNewList(Object ... values) {
        ArrayList result = new ArrayList();
        return this.concatenateIntoList(result, values);
    }

    public boolean documentExists(CoreSession session, String idOrPath) {
        PathRef documentRef = idOrPath.startsWith("/") ? new PathRef(idOrPath) : new IdRef(idOrPath);
        return session.exists((DocumentRef)documentRef);
    }
}

