/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.audit.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.ecm.platform.audit.api.AuditStorage;
import org.nuxeo.ecm.platform.audit.api.DocumentHistoryReader;
import org.nuxeo.ecm.platform.audit.api.document.DocumentHistoryReaderImpl;
import org.nuxeo.ecm.platform.audit.service.AuditBackend;
import org.nuxeo.ecm.platform.audit.service.AuditBulker;
import org.nuxeo.ecm.platform.audit.service.extension.AdapterDescriptor;
import org.nuxeo.ecm.platform.audit.service.extension.AuditBackendDescriptor;
import org.nuxeo.ecm.platform.audit.service.extension.AuditBulkerDescriptor;
import org.nuxeo.ecm.platform.audit.service.extension.AuditStorageDescriptor;
import org.nuxeo.ecm.platform.audit.service.extension.ExtendedInfoDescriptor;
import org.nuxeo.runtime.RuntimeMessage;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.logging.DeprecationLogger;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentManager;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;

public class NXAuditEventsService
extends DefaultComponent
implements ComponentManager.Listener {
    private static final Logger log = LogManager.getLogger(NXAuditEventsService.class);
    public static final ComponentName NAME = new ComponentName("org.nuxeo.ecm.platform.audit.service.NXAuditEventsService");
    private static final String EVENT_EXT_POINT = "event";
    private static final String EXTENDED_INFO_EXT_POINT = "extendedInfo";
    private static final String ADAPTER_POINT = "adapter";
    private static final String BACKEND_EXT_POINT = "backend";
    private static final String STORAGE_EXT_POINT = "storage";
    public static final String DISABLE_AUDIT_LOGGER = "disableAuditLogger";
    protected Map<String, List<ExtendedInfoDescriptor>> eventExtendedInfoDescriptors;
    protected Set<String> eventNames;
    protected AuditBackend backend;
    protected static final AuditBackendDescriptor DEFAULT_BACKEND_CONFIG = new AuditBackendDescriptor();
    @Deprecated(since="10.10")
    protected AuditBulker bulker;
    @Deprecated(since="10.10")
    protected AuditBulkerDescriptor bulkerConfig = new AuditBulkerDescriptor();
    protected Map<String, AuditStorage> auditStorages;

    protected AuditBackendDescriptor getAuditBackendDescriptor() {
        return this.getRegistryContribution(BACKEND_EXT_POINT).orElse(DEFAULT_BACKEND_CONFIG);
    }

    public int getApplicationStartedOrder() {
        return this.getAuditBackendDescriptor().getApplicationStartedOrder();
    }

    public void start(ComponentContext context) {
        this.eventExtendedInfoDescriptors = new HashMap<String, List<ExtendedInfoDescriptor>>();
        this.eventNames = new HashSet<String>();
        this.getRegistryContributions(EVENT_EXT_POINT).forEach(desc -> {
            String eventName = desc.getName();
            this.eventNames.add(eventName);
            desc.getExtendedInfoDescriptors().stream().filter(ExtendedInfoDescriptor::getEnabled).forEach(extInfoDesc -> this.eventExtendedInfoDescriptors.computeIfAbsent(eventName, k -> new ArrayList()).add(extInfoDesc));
            log.debug("Registered event: {}", (Object)eventName);
        });
        this.backend = this.getAuditBackendDescriptor().newInstance(this);
        this.backend.onApplicationStarted();
        if (Framework.isBooleanPropertyFalse((String)"nuxeo.stream.audit.enabled")) {
            this.bulker = this.bulkerConfig.newInstance(this.backend);
            this.bulker.onApplicationStarted();
        }
    }

    public void afterRuntimeStart(ComponentManager mgr, boolean isResume) {
        this.auditStorages = new HashMap<String, AuditStorage>();
        for (AuditStorageDescriptor descriptor : this.getRegistryContributions(STORAGE_EXT_POINT)) {
            AuditStorage storage = descriptor.newInstance();
            if (storage instanceof AuditBackend) {
                ((AuditBackend)storage).onApplicationStarted();
            }
            this.auditStorages.put(descriptor.getId(), storage);
        }
    }

    public void stop(ComponentContext context) {
        this.eventNames.clear();
        this.eventExtendedInfoDescriptors.clear();
        try {
            if (this.bulker != null) {
                this.bulker.onApplicationStopped();
            }
        }
        finally {
            this.backend.onApplicationStopped();
            this.backend = null;
            this.auditStorages.values().forEach(storage -> {
                if (storage instanceof AuditBackend) {
                    ((AuditBackend)storage).onApplicationStopped();
                }
            });
            this.auditStorages = null;
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == NXAuditEventsService.class) {
            return adapter.cast((Object)this);
        }
        if (adapter.getCanonicalName().equals(DocumentHistoryReader.class.getCanonicalName())) {
            return adapter.cast(new DocumentHistoryReaderImpl());
        }
        if (this.backend != null) {
            return adapter.cast(this.backend);
        }
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = adapter::getCanonicalName;
        log.error("Can not provide service {} since backend is undefined", supplierArray);
        return null;
    }

    public Set<String> getAuditableEventNames() {
        return Collections.unmodifiableSet(this.eventNames);
    }

    public AuditBackend getBackend() {
        return this.backend;
    }

    public Set<AdapterDescriptor> getDocumentAdapters() {
        return new HashSet<AdapterDescriptor>(this.getRegistryContributions(ADAPTER_POINT));
    }

    public Map<String, List<ExtendedInfoDescriptor>> getEventExtendedInfoDescriptors() {
        return Collections.unmodifiableMap(this.eventExtendedInfoDescriptors);
    }

    public Set<ExtendedInfoDescriptor> getExtendedInfoDescriptors() {
        return new HashSet<ExtendedInfoDescriptor>(this.getRegistryContributions(EXTENDED_INFO_EXT_POINT));
    }

    public AuditStorage getAuditStorage(String id) {
        return this.auditStorages.get(id);
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (contribution instanceof AuditBulkerDescriptor) {
            this.bulkerConfig = (AuditBulkerDescriptor)contribution;
            ComponentName compName = contributor.getName();
            String message = String.format("AuditBulker on component %s is deprecated because it is now handled with nuxeo-stream, no replacement.", compName);
            DeprecationLogger.log((String)message, (String)"10.10");
            this.addRuntimeMessage(RuntimeMessage.Level.WARNING, message, RuntimeMessage.Source.EXTENSION, compName.getName());
        }
    }
}

