/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.core;

import io.dropwizard.metrics5.MetricName;
import io.dropwizard.metrics5.MetricRegistry;
import io.dropwizard.metrics5.SharedMetricRegistries;
import io.dropwizard.metrics5.Timer;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.bucket.filter.Filter;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.platform.query.api.Aggregate;
import org.nuxeo.ecm.platform.query.api.Bucket;
import org.nuxeo.elasticsearch.aggregate.AggregateEsBase;
import org.nuxeo.elasticsearch.api.ElasticSearchService;
import org.nuxeo.elasticsearch.api.EsResult;
import org.nuxeo.elasticsearch.api.EsScrollResult;
import org.nuxeo.elasticsearch.core.ElasticSearchAdminImpl;
import org.nuxeo.elasticsearch.core.EsResultSetImpl;
import org.nuxeo.elasticsearch.fetcher.Fetcher;
import org.nuxeo.elasticsearch.query.NxQueryBuilder;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.metrics.MetricsService;

public class ElasticSearchServiceImpl
implements ElasticSearchService {
    private static final Log log = LogFactory.getLog(ElasticSearchServiceImpl.class);
    private static final String LOG_MIN_DURATION_FETCH_KEY = "org.nuxeo.elasticsearch.core.log_min_duration_fetch_ms";
    private static final long LOG_MIN_DURATION_FETCH_NS = Long.parseLong(Framework.getProperty((String)"org.nuxeo.elasticsearch.core.log_min_duration_fetch_ms", (String)"200")) * 1000000L;
    protected final MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)MetricsService.class.getName());
    protected final Timer searchTimer;
    protected final Timer scrollTimer;
    protected final Timer fetchTimer;
    private final ElasticSearchAdminImpl esa;

    public ElasticSearchServiceImpl(ElasticSearchAdminImpl esa) {
        this.esa = esa;
        this.searchTimer = this.registry.timer(MetricName.build((String[])new String[]{"nuxeo.elasticsearch.service.timer"}).tagged(new String[]{"service", "search"}));
        this.scrollTimer = this.registry.timer(MetricName.build((String[])new String[]{"nuxeo.elasticsearch.service.timer"}).tagged(new String[]{"service", "scroll"}));
        this.fetchTimer = this.registry.timer(MetricName.build((String[])new String[]{"nuxeo.elasticsearch.service.timer"}).tagged(new String[]{"service", "fetch"}));
    }

    @Override
    @Deprecated
    public DocumentModelList query(CoreSession session, String nxql, int limit, int offset, SortInfo ... sortInfos) {
        NxQueryBuilder query = new NxQueryBuilder(session).nxql(nxql).limit(limit).offset(offset).addSort(sortInfos);
        return this.query(query);
    }

    @Override
    @Deprecated
    public DocumentModelList query(CoreSession session, QueryBuilder queryBuilder, int limit, int offset, SortInfo ... sortInfos) {
        NxQueryBuilder query = new NxQueryBuilder(session).esQuery(queryBuilder).limit(limit).offset(offset).addSort(sortInfos);
        return this.query(query);
    }

    @Override
    public DocumentModelList query(NxQueryBuilder queryBuilder) {
        return this.queryAndAggregate(queryBuilder).getDocuments();
    }

    @Override
    public EsResult queryAndAggregate(NxQueryBuilder queryBuilder) {
        SearchResponse response = this.search(queryBuilder);
        List<Aggregate<Bucket>> aggs = this.getAggregates(queryBuilder, response);
        if (queryBuilder.returnsDocuments()) {
            DocumentModelListImpl docs = this.getDocumentModels(queryBuilder, response);
            return new EsResult((DocumentModelList)docs, aggs, response);
        }
        if (queryBuilder.returnsRows()) {
            IterableQueryResult rows = this.getRows(queryBuilder, response);
            return new EsResult(rows, aggs, response);
        }
        return new EsResult(response);
    }

    @Override
    public EsScrollResult scroll(NxQueryBuilder queryBuilder, long keepAlive) {
        return this.scroll(queryBuilder, SearchType.DFS_QUERY_THEN_FETCH, keepAlive);
    }

    protected EsScrollResult scroll(NxQueryBuilder queryBuilder, SearchType searchType, long keepAlive) {
        SearchResponse response = this.searchScroll(queryBuilder, searchType, keepAlive);
        return this.getScrollResults(queryBuilder, response, response.getScrollId(), keepAlive);
    }

    @Override
    public EsScrollResult scroll(EsScrollResult scrollResult) {
        SearchResponse response = this.nextScroll(scrollResult.getScrollId(), scrollResult.getKeepAlive());
        return this.getScrollResults(scrollResult.getQueryBuilder(), response, response.getScrollId(), scrollResult.getKeepAlive());
    }

    @Override
    public void clearScroll(EsScrollResult scrollResult) {
        this.clearScroll(scrollResult.getScrollId());
    }

    protected void clearScroll(String scrollId) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Clear scroll : curl -XDELETE 'http://localhost:9200/_search/scroll' -d '{\"scroll_id\" : [\"%s\"]}'", scrollId));
        }
        ClearScrollRequest request = new ClearScrollRequest();
        request.addScrollId(scrollId);
        this.esa.getClient().clearScroll(request);
    }

    protected EsScrollResult getScrollResults(NxQueryBuilder queryBuilder, SearchResponse response, String scrollId, long keepAlive) {
        if (queryBuilder.returnsDocuments()) {
            DocumentModelListImpl docs = this.getDocumentModels(queryBuilder, response);
            return new EsScrollResult((DocumentModelList)docs, response, queryBuilder, scrollId, keepAlive);
        }
        if (queryBuilder.returnsRows()) {
            IterableQueryResult rows = this.getRows(queryBuilder, response);
            return new EsScrollResult(rows, response, queryBuilder, scrollId, keepAlive);
        }
        return new EsScrollResult(response, queryBuilder, scrollId, keepAlive);
    }

    protected DocumentModelListImpl getDocumentModels(NxQueryBuilder queryBuilder, SearchResponse response) {
        DocumentModelListImpl ret;
        long totalSize = response.getHits().getTotalHits().value;
        if (!queryBuilder.returnsDocuments() || response.getHits().getHits().length == 0) {
            DocumentModelListImpl ret2 = new DocumentModelListImpl(0);
            ret2.setTotalSize(totalSize);
            return ret2;
        }
        try (Timer.Context stopWatch = this.fetchTimer.time();){
            Fetcher fetcher = queryBuilder.getFetcher(response, this.esa.getRepositoryMap());
            ret = fetcher.fetchDocuments();
            this.logMinDurationFetch(stopWatch.stop(), totalSize);
        }
        ret.setTotalSize(totalSize);
        return ret;
    }

    private void logMinDurationFetch(long duration, long totalSize) {
        if (log.isDebugEnabled() && duration > LOG_MIN_DURATION_FETCH_NS) {
            String msg = String.format("Slow fetch duration_ms:\t%.2f\treturning:\t%d documents", (double)duration / 1000000.0, totalSize);
            if (log.isTraceEnabled()) {
                log.trace((Object)msg, new Throwable("Slow fetch document stack trace"));
            } else {
                log.debug((Object)msg);
            }
        }
    }

    protected List<Aggregate<Bucket>> getAggregates(NxQueryBuilder queryBuilder, SearchResponse response) {
        for (AggregateEsBase<Aggregation, Bucket> agg : queryBuilder.getAggregates()) {
            Aggregation aggregation;
            Filter filter = (Filter)response.getAggregations().get(NxQueryBuilder.getAggregateFilterId(agg));
            if (filter == null || (aggregation = filter.getAggregations().get(agg.getId())) == null) continue;
            agg.parseAggregation(aggregation);
        }
        List<AggregateEsBase<Aggregation, Bucket>> ret = queryBuilder.getAggregates();
        return ret;
    }

    private IterableQueryResult getRows(NxQueryBuilder queryBuilder, SearchResponse response) {
        return new EsResultSetImpl(response, queryBuilder.getSelectFieldsAndTypes());
    }

    protected SearchResponse search(NxQueryBuilder query) {
        try (Timer.Context ignored = this.searchTimer.time();){
            SearchType searchType = SearchType.DFS_QUERY_THEN_FETCH;
            SearchRequest request = this.buildEsSearchRequest(query, searchType);
            this.logSearchRequest(request, query, searchType);
            SearchResponse response = this.esa.getClient().search(request);
            this.logSearchResponse(response);
            SearchResponse searchResponse = response;
            return searchResponse;
        }
    }

    protected SearchResponse searchScroll(NxQueryBuilder query, SearchType searchType, long keepAlive) {
        try (Timer.Context ignored = this.searchTimer.time();){
            SearchRequest request = this.buildEsSearchScrollRequest(query, searchType, keepAlive);
            this.logSearchRequest(request, query, searchType);
            SearchResponse response = this.esa.getClient().search(request);
            this.logSearchResponse(response);
            SearchResponse searchResponse = response;
            return searchResponse;
        }
    }

    protected SearchResponse nextScroll(String scrollId, long keepAlive) {
        try (Timer.Context ignored = this.scrollTimer.time();){
            SearchScrollRequest request = this.buildEsScrollRequest(scrollId, keepAlive);
            this.logScrollRequest(scrollId, keepAlive);
            SearchResponse response = this.esa.getClient().searchScroll(request);
            this.logSearchResponse(response);
            SearchResponse searchResponse = response;
            return searchResponse;
        }
    }

    protected SearchRequest buildEsSearchRequest(NxQueryBuilder query, SearchType searchType) {
        SearchRequest request = new SearchRequest(this.esa.getSearchIndexes(query.getSearchRepositories()));
        request.searchType(searchType);
        SearchSourceBuilder search = new SearchSourceBuilder();
        query.updateRequest(search);
        request.source(search);
        if (query.isFetchFromElasticsearch()) {
            search.fetchSource(this.esa.getIncludeSourceFields(), this.esa.getExcludeSourceFields());
        }
        return request;
    }

    protected SearchRequest buildEsSearchScrollRequest(NxQueryBuilder query, SearchType searchType, long keepAlive) {
        SearchRequest request = this.buildEsSearchRequest(query, searchType);
        request.scroll(new TimeValue(keepAlive));
        return request;
    }

    protected SearchScrollRequest buildEsScrollRequest(String scrollId, long keepAlive) {
        return new SearchScrollRequest(scrollId).scroll(new TimeValue(keepAlive));
    }

    protected void logSearchResponse(SearchResponse response) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Response: " + response.toString()));
        }
    }

    protected void logSearchRequest(SearchRequest request, NxQueryBuilder query, SearchType searchType) {
        if (log.isDebugEnabled()) {
            String scroll = request.scroll() != null ? "&scroll=" + request.scroll() : "";
            log.debug((Object)String.format("Search query: curl -XGET 'http://localhost:9200/%s/_search?pretty&search_type=%s%s' -d '%s'", this.getSearchIndexesAsString(query), searchType.toString().toLowerCase(), scroll, request.source().toString()));
        }
    }

    protected void logScrollRequest(String scrollId, long keepAlive) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Scroll search: curl -XGET 'http://localhost:9200/_search/scroll?pretty' -d '{\"scroll\" : \"%d\", \"scroll_id\" : \"%s\"}'", keepAlive, scrollId));
        }
    }

    protected String getSearchIndexesAsString(NxQueryBuilder query) {
        return StringUtils.join((Object[])this.esa.getSearchIndexes(query.getSearchRepositories()), (char)',');
    }
}

