/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.query;

import java.io.Reader;
import java.io.StringReader;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchPhrasePrefixQueryBuilder;
import org.elasticsearch.index.query.MoreLikeThisQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.SimpleQueryStringBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentNotFoundException;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.core.api.trash.TrashService;
import org.nuxeo.ecm.core.query.QueryParseException;
import org.nuxeo.ecm.core.query.sql.NXQL;
import org.nuxeo.ecm.core.query.sql.SQLQueryParser;
import org.nuxeo.ecm.core.query.sql.model.DefaultQueryVisitor;
import org.nuxeo.ecm.core.query.sql.model.EsHint;
import org.nuxeo.ecm.core.query.sql.model.Expression;
import org.nuxeo.ecm.core.query.sql.model.FromClause;
import org.nuxeo.ecm.core.query.sql.model.FromList;
import org.nuxeo.ecm.core.query.sql.model.Function;
import org.nuxeo.ecm.core.query.sql.model.IVisitor;
import org.nuxeo.ecm.core.query.sql.model.Literal;
import org.nuxeo.ecm.core.query.sql.model.LiteralList;
import org.nuxeo.ecm.core.query.sql.model.MultiExpression;
import org.nuxeo.ecm.core.query.sql.model.Operand;
import org.nuxeo.ecm.core.query.sql.model.Operator;
import org.nuxeo.ecm.core.query.sql.model.OrderByExpr;
import org.nuxeo.ecm.core.query.sql.model.Predicate;
import org.nuxeo.ecm.core.query.sql.model.Reference;
import org.nuxeo.ecm.core.query.sql.model.SQLQuery;
import org.nuxeo.ecm.core.query.sql.model.SelectClause;
import org.nuxeo.ecm.core.query.sql.model.StringLiteral;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.schema.utils.DateParser;
import org.nuxeo.ecm.core.security.SecurityService;
import org.nuxeo.elasticsearch.api.ElasticSearchAdmin;
import org.nuxeo.elasticsearch.hint.MoreLikeThisESHintQueryBuilder;
import org.nuxeo.runtime.api.Framework;

public final class NxqlQueryConverter {
    protected static final String SELECT_ALL = "SELECT * FROM Document";
    protected static final String SELECT_ALL_WHERE = "SELECT * FROM Document WHERE ";
    protected static final String SIMPLE_QUERY_PREFIX = "es: ";
    @Deprecated
    protected static final int MORE_LIKE_THIS_MIN_TERM_FREQ = 1;
    @Deprecated
    protected static final int MORE_LIKE_THIS_MIN_DOC_FREQ = 3;
    @Deprecated
    protected static final int MORE_LIKE_THIS_MAX_QUERY_TERMS = 12;

    private NxqlQueryConverter() {
    }

    public static QueryBuilder toESQueryBuilder(String nxql) {
        return NxqlQueryConverter.toESQueryBuilder(nxql, null);
    }

    public static QueryBuilder toESQueryBuilder(String nxql, final CoreSession session) {
        final LinkedList<ExpressionBuilder> builders = new LinkedList<ExpressionBuilder>();
        SQLQuery nxqlQuery = NxqlQueryConverter.getSqlQuery(nxql);
        if (session != null) {
            nxqlQuery = NxqlQueryConverter.addSecurityPolicy(session, nxqlQuery);
        }
        ExpressionBuilder ret = new ExpressionBuilder(null);
        builders.add(ret);
        final ArrayList fromList = new ArrayList();
        nxqlQuery.accept((IVisitor)new DefaultQueryVisitor(){

            public void visitFromClause(FromClause node) {
                FromList elements = node.elements;
                SchemaManager schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
                for (String type : elements.values()) {
                    if ("Document".equalsIgnoreCase(type)) {
                        fromList.clear();
                        return;
                    }
                    Set types = schemaManager.getDocumentTypeNamesExtending(type);
                    if (types == null) continue;
                    fromList.addAll(types);
                }
            }

            public void visitMultiExpression(MultiExpression node) {
                Iterator it = node.predicates.iterator();
                while (it.hasNext()) {
                    ((Predicate)it.next()).accept((IVisitor)this);
                    if (!it.hasNext()) continue;
                    node.operator.accept((IVisitor)this);
                }
            }

            public void visitSelectClause(SelectClause node) {
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void visitExpression(Expression node) {
                Operator op = node.operator;
                if (op == Operator.AND || op == Operator.OR || op == Operator.NOT) {
                    builders.add(new ExpressionBuilder(op.toString()));
                    super.visitExpression(node);
                    ExpressionBuilder expr = (ExpressionBuilder)builders.removeLast();
                    if (builders.isEmpty()) return;
                    ((ExpressionBuilder)builders.getLast()).merge(expr);
                    return;
                } else {
                    Reference ref = node.lvalue instanceof Reference ? (Reference)node.lvalue : null;
                    String name = ref != null ? ref.name : node.lvalue.toString();
                    String value = null;
                    if (node.rvalue instanceof Literal) {
                        value = ((Literal)node.rvalue).asString();
                    } else if (node.rvalue instanceof Function) {
                        Function function = (Function)node.rvalue;
                        String func = function.name;
                        if (!"NOW".equalsIgnoreCase(func)) throw new IllegalArgumentException("Unknown function: " + func);
                        String periodAndDurationText = function.args == null || function.args.size() != 1 ? null : ((StringLiteral)function.args.get((int)0)).value;
                        ZonedDateTime dateTime = NXQL.nowPlusPeriodAndDuration(periodAndDurationText);
                        GregorianCalendar calendar = GregorianCalendar.from(dateTime);
                        value = DateParser.formatW3CDateTime((Calendar)calendar);
                    } else if (node.rvalue != null) {
                        value = node.rvalue.toString();
                    }
                    Object[] values = null;
                    if (node.rvalue instanceof LiteralList) {
                        LiteralList items = (LiteralList)node.rvalue;
                        values = new Object[items.size()];
                        int i = 0;
                        for (Literal item : items) {
                            values[i++] = item.asString();
                        }
                    }
                    EsHint hint = ref != null ? ref.esHint : null;
                    ((ExpressionBuilder)builders.getLast()).add(NxqlQueryConverter.makeQueryFromSimpleExpression(op.toString(), name, value, values, hint, session));
                }
            }
        });
        QueryBuilder queryBuilder = ret.get();
        if (!fromList.isEmpty()) {
            return QueryBuilders.boolQuery().must(queryBuilder).filter(NxqlQueryConverter.makeQueryFromSimpleExpression((String)"IN", (String)"ecm:primaryType", null, (Object[])fromList.toArray(), null, null).filter);
        }
        return queryBuilder;
    }

    protected static SQLQuery getSqlQuery(String nxql) {
        SQLQuery nxqlQuery;
        String query = NxqlQueryConverter.completeQueryWithSelect(nxql);
        try {
            nxqlQuery = SQLQueryParser.parse((Reader)new StringReader(query));
        }
        catch (QueryParseException e) {
            e.addInfo("Query: " + query);
            throw e;
        }
        return nxqlQuery;
    }

    protected static SQLQuery addSecurityPolicy(CoreSession session, SQLQuery query) {
        Collection transformers = ((SecurityService)Framework.getService(SecurityService.class)).getPoliciesQueryTransformers(session.getRepositoryName());
        for (SQLQuery.Transformer trans : transformers) {
            query = trans.transform(session.getPrincipal(), query);
        }
        return query;
    }

    protected static String completeQueryWithSelect(String nxql) {
        Object query;
        Object object = query = nxql == null ? "" : nxql.trim();
        if (((String)query).isEmpty()) {
            query = SELECT_ALL;
        } else if (!((String)query).toLowerCase().startsWith("select ")) {
            query = SELECT_ALL_WHERE + nxql;
        }
        return query;
    }

    public static QueryAndFilter makeQueryFromSimpleExpression(String op, String nxqlName, Object value, Object[] values, EsHint hint, CoreSession session) {
        QueryBuilder query = null;
        QueryBuilder filter = null;
        String name = NxqlQueryConverter.getFieldName(nxqlName, hint);
        if (hint != null && hint.operator != null) {
            if (ArrayUtils.isNotEmpty((Object[])values)) {
                filter = NxqlQueryConverter.makeHintQuery(name, values, hint);
            } else {
                query = NxqlQueryConverter.makeHintQuery(name, value, hint);
            }
        } else if (nxqlName.startsWith("ecm:fulltext") && ("=".equals(op) || "!=".equals(op) || "<>".equals(op) || "LIKE".equals(op) || "NOT LIKE".equals(op))) {
            query = NxqlQueryConverter.makeFulltextQuery(nxqlName, (String)value, hint);
            if ("!=".equals(op) || "<>".equals(op) || "NOT LIKE".equals(op)) {
                filter = QueryBuilders.boolQuery().mustNot(query);
                query = null;
            }
        } else if (nxqlName.startsWith("ecm:ancestorId")) {
            filter = NxqlQueryConverter.makeAncestorIdFilter((String)value, session);
            if ("!=".equals(op) || "<>".equals(op)) {
                filter = QueryBuilders.boolQuery().mustNot(filter);
            }
        } else if (nxqlName.equals("ecm:isTrashed")) {
            filter = NxqlQueryConverter.makeTrashedFilter(op, name, (String)value);
        } else {
            switch (op) {
                case "=": {
                    filter = QueryBuilders.termQuery((String)name, (Object)NxqlQueryConverter.checkBoolValue(nxqlName, value));
                    break;
                }
                case "<>": 
                case "!=": {
                    filter = QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.termQuery((String)name, (Object)NxqlQueryConverter.checkBoolValue(nxqlName, value)));
                    break;
                }
                case ">": {
                    filter = QueryBuilders.rangeQuery((String)name).gt(value);
                    break;
                }
                case "<": {
                    filter = QueryBuilders.rangeQuery((String)name).lt(value);
                    break;
                }
                case ">=": {
                    filter = QueryBuilders.rangeQuery((String)name).gte(value);
                    break;
                }
                case "<=": {
                    filter = QueryBuilders.rangeQuery((String)name).lte(value);
                    break;
                }
                case "BETWEEN": 
                case "NOT BETWEEN": {
                    filter = QueryBuilders.rangeQuery((String)name).from(values[0]).to(values[1]);
                    if (!op.startsWith("NOT")) break;
                    filter = QueryBuilders.boolQuery().mustNot(filter);
                    break;
                }
                case "IN": 
                case "NOT IN": {
                    filter = QueryBuilders.termsQuery((String)name, (Object[])values);
                    if (!op.startsWith("NOT")) break;
                    filter = QueryBuilders.boolQuery().mustNot(filter);
                    break;
                }
                case "IS NULL": {
                    filter = QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.existsQuery((String)name));
                    break;
                }
                case "IS NOT NULL": {
                    filter = QueryBuilders.existsQuery((String)name);
                    break;
                }
                case "LIKE": 
                case "ILIKE": 
                case "NOT LIKE": 
                case "NOT ILIKE": {
                    query = NxqlQueryConverter.makeLikeQuery(op, name, (String)value, hint);
                    if (!op.startsWith("NOT")) break;
                    filter = QueryBuilders.boolQuery().mustNot(query);
                    query = null;
                    break;
                }
                case "STARTSWITH": {
                    filter = NxqlQueryConverter.makeStartsWithQuery(name, value);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Operator: '" + op + "' is unknown");
                }
            }
        }
        return new QueryAndFilter(query, filter);
    }

    protected static Object checkBoolValue(String nxqlName, Object value) {
        if (!"0".equals(value) && !"1".equals(value)) {
            return value;
        }
        switch (nxqlName) {
            case "ecm:isProxy": 
            case "ecm:isCheckedIn": 
            case "ecm:isTrashed": 
            case "ecm:isVersion": 
            case "ecm:isCheckedInVersion": 
            case "ecm:isRecord": 
            case "ecm:hasLegalHold": 
            case "ecm:isLatestMajorVersion": 
            case "ecm:isLatestVersion": {
                break;
            }
            default: {
                SchemaManager schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
                Field field = schemaManager.getField(nxqlName);
                if (field != null && "boolean".equals(field.getType().getName())) break;
                return value;
            }
        }
        return "0".equals(value) ? "false" : "true";
    }

    protected static QueryBuilder makeTrashedFilter(String op, String name, String value) {
        boolean equalsDeleted;
        switch (op) {
            case "=": {
                equalsDeleted = true;
                break;
            }
            case "<>": 
            case "!=": {
                equalsDeleted = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("ecm:isTrashed requires = or <> operator");
            }
        }
        if ("0".equals(value)) {
            equalsDeleted = !equalsDeleted;
        } else if (!"1".equals(value)) {
            throw new IllegalArgumentException("ecm:isTrashed requires literal 0 or 1 as right argument");
        }
        TrashService trashService = (TrashService)Framework.getService(TrashService.class);
        TermQueryBuilder filter = null;
        if (trashService.hasFeature(TrashService.Feature.TRASHED_STATE_IS_DEDUCED_FROM_LIFECYCLE)) {
            filter = QueryBuilders.termQuery((String)"ecm:currentLifeCycleState", (String)"deleted");
        } else if (trashService.hasFeature(TrashService.Feature.TRASHED_STATE_IN_MIGRATION)) {
            filter = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.termQuery((String)"ecm:currentLifeCycleState", (String)"deleted")).should((QueryBuilder)QueryBuilders.termQuery((String)name, (boolean)true));
        } else if (trashService.hasFeature(TrashService.Feature.TRASHED_STATE_IS_DEDICATED_PROPERTY)) {
            filter = QueryBuilders.termQuery((String)name, (boolean)true);
        }
        if (!equalsDeleted) {
            filter = QueryBuilders.boolQuery().mustNot((QueryBuilder)filter);
        }
        return filter;
    }

    protected static QueryBuilder makeHintQuery(String name, Object value, EsHint hint) {
        return ((ElasticSearchAdmin)Framework.getService(ElasticSearchAdmin.class)).getHintByOperator(hint.operator).orElseThrow(() -> new UnsupportedOperationException(String.format("Operator: %s is unknown", hint.operator))).make(hint, name, value);
    }

    @Deprecated
    protected static MoreLikeThisQueryBuilder.Item[] getItems(Object value) {
        return MoreLikeThisESHintQueryBuilder.getItems(value);
    }

    public static QueryBuilder makeStartsWithQuery(String name, Object value) {
        Object filter;
        String indexName = name + ".children";
        if ("/".equals(value)) {
            filter = "ecm:path".equals(name) ? QueryBuilders.existsQuery((String)"ecm:parentId") : QueryBuilders.existsQuery((String)indexName);
        } else {
            String v = String.valueOf(value);
            if (v.endsWith("/")) {
                v = v.replaceAll("/$", "");
            }
            filter = "ecm:path".equals(name) ? QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)indexName, (String)v)).mustNot((QueryBuilder)QueryBuilders.termQuery((String)name, (Object)value)) : QueryBuilders.termQuery((String)indexName, (String)v);
        }
        return filter;
    }

    protected static QueryBuilder makeAncestorIdFilter(String value, CoreSession session) {
        String path;
        if (session == null) {
            return QueryBuilders.existsQuery((String)"ancestorid-without-session");
        }
        try {
            DocumentModel doc = session.getDocument((DocumentRef)new IdRef(value));
            path = doc.getPathAsString();
        }
        catch (DocumentNotFoundException e) {
            return QueryBuilders.existsQuery((String)"ancestorid-not-found");
        }
        return NxqlQueryConverter.makeStartsWithQuery("ecm:path", path);
    }

    protected static QueryBuilder makeLikeQuery(String op, String name, String value, EsHint hint) {
        String wildcard;
        Object fieldName = name;
        if (op.contains("ILIKE")) {
            value = value.toLowerCase();
            fieldName = name + ".lowercase";
        }
        if (hint != null && hint.index != null) {
            fieldName = hint.index;
        }
        if (StringUtils.countMatches((CharSequence)(wildcard = NxqlQueryConverter.likeToWildcard(value)), (CharSequence)"*") == 1 && wildcard.endsWith("*") && !wildcard.contains("?") && !wildcard.contains("\\")) {
            MatchPhrasePrefixQueryBuilder query = QueryBuilders.matchPhrasePrefixQuery((String)fieldName, (Object)wildcard.replace("*", ""));
            if (hint != null && hint.analyzer != null) {
                query.analyzer(hint.analyzer);
            }
            return query;
        }
        return QueryBuilders.wildcardQuery((String)fieldName, (String)wildcard);
    }

    protected static String likeToWildcard(String like) {
        StringBuilder wildcard = new StringBuilder();
        char[] chars = like.toCharArray();
        boolean escape = false;
        for (char c : chars) {
            boolean escapeNext = false;
            switch (c) {
                case '?': {
                    wildcard.append("\\?");
                    break;
                }
                case '%': 
                case '*': {
                    if (escape) {
                        wildcard.append(c);
                        break;
                    }
                    wildcard.append("*");
                    break;
                }
                case '_': {
                    if (escape) {
                        wildcard.append(c);
                        break;
                    }
                    wildcard.append("?");
                    break;
                }
                case '\\': {
                    if (escape) {
                        wildcard.append("\\\\");
                        break;
                    }
                    escapeNext = true;
                    break;
                }
                default: {
                    wildcard.append(c);
                }
            }
            escape = escapeNext;
        }
        if (escape) {
            // empty if block
        }
        return wildcard.toString();
    }

    protected static QueryBuilder makeFulltextQuery(String nxqlName, String value, EsHint hint) {
        org.elasticsearch.index.query.Operator defaultOperator;
        Object name = nxqlName.replace("ecm:fulltext", "");
        name = ((String)name).startsWith(".") ? ((String)name).substring(1) + ".fulltext" : "all_field";
        String queryString = value;
        if (queryString.startsWith(SIMPLE_QUERY_PREFIX)) {
            queryString = queryString.substring(SIMPLE_QUERY_PREFIX.length());
            defaultOperator = org.elasticsearch.index.query.Operator.OR;
        } else {
            queryString = NxqlQueryConverter.translateFulltextQuery(queryString);
            defaultOperator = org.elasticsearch.index.query.Operator.AND;
        }
        String analyzer = hint != null && hint.analyzer != null ? hint.analyzer : "fulltext";
        SimpleQueryStringBuilder query = QueryBuilders.simpleQueryStringQuery((String)queryString).defaultOperator(defaultOperator).analyzer(analyzer);
        if (hint != null && hint.index != null) {
            for (EsHint.FieldHint fieldHint : hint.getIndex()) {
                query.field(fieldHint.getField(), fieldHint.getBoost());
            }
        } else {
            query.field((String)name);
        }
        return query;
    }

    protected static String getFieldName(String name, EsHint hint) {
        if (hint != null && hint.index != null) {
            return hint.index;
        }
        if ("ecm:isCheckedInVersion".equals(name)) {
            name = "ecm:isVersion";
        }
        name = name.replace("/*", "");
        name = name.replace("/", ".");
        return name;
    }

    public static List<SortInfo> getSortInfo(String nxql) {
        final ArrayList<SortInfo> sortInfos = new ArrayList<SortInfo>();
        SQLQuery nxqlQuery = NxqlQueryConverter.getSqlQuery(nxql);
        nxqlQuery.accept((IVisitor)new DefaultQueryVisitor(){

            public void visitOrderByExpr(OrderByExpr node) {
                String name = NxqlQueryConverter.getFieldName(node.reference.name, null);
                if ("ecm:fulltextScore".equals(name)) {
                    name = "_score";
                }
                sortInfos.add(new SortInfo(name, !node.isDescending));
            }
        });
        return sortInfos;
    }

    public static Map<String, Type> getSelectClauseFields(String nxql) {
        final LinkedHashMap<String, Type> fieldsAndTypes = new LinkedHashMap<String, Type>();
        SQLQuery nxqlQuery = NxqlQueryConverter.getSqlQuery(nxql);
        nxqlQuery.accept((IVisitor)new DefaultQueryVisitor(){

            public void visitSelectClause(SelectClause selectClause) {
                SchemaManager schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
                for (int i = 0; i < selectClause.getSelectList().size(); ++i) {
                    String name;
                    Operand op = selectClause.get(i);
                    if (!(op instanceof Reference)) continue;
                    Field field = schemaManager.getField(name = ((Reference)op).name);
                    fieldsAndTypes.put(name, field == null ? null : field.getType());
                }
            }
        });
        return fieldsAndTypes;
    }

    public static String translateFulltextQuery(String query) {
        return query.replace(" OR ", " | ").replace(" or ", " | ");
    }

    public static class ExpressionBuilder {
        public final String operator;
        public QueryBuilder query;

        public ExpressionBuilder(String op) {
            this.operator = op;
            this.query = null;
        }

        public void add(QueryAndFilter qf) {
            if (qf != null) {
                this.add(qf.query, qf.filter);
            }
        }

        public void add(QueryBuilder q) {
            this.add(q, null);
        }

        public void add(QueryBuilder q, QueryBuilder f) {
            if (q == null && f == null) {
                return;
            }
            QueryBuilder inputQuery = q;
            if (inputQuery == null) {
                inputQuery = QueryBuilders.constantScoreQuery((QueryBuilder)f);
            }
            if (this.operator == null) {
                this.query = inputQuery;
            } else {
                if (this.query == null) {
                    this.query = QueryBuilders.boolQuery();
                }
                BoolQueryBuilder boolQuery = (BoolQueryBuilder)this.query;
                if ("AND".equals(this.operator)) {
                    boolQuery.must(inputQuery);
                } else if ("OR".equals(this.operator)) {
                    boolQuery.should(inputQuery);
                } else if ("NOT".equals(this.operator)) {
                    boolQuery.mustNot(inputQuery);
                }
            }
        }

        public void merge(ExpressionBuilder expr) {
            if (expr.operator != null && expr.operator.equals(this.operator) && this.query == null) {
                this.query = expr.query;
            } else {
                this.add(new QueryAndFilter(expr.query, null));
            }
        }

        public QueryBuilder get() {
            if (this.query == null) {
                return QueryBuilders.matchAllQuery();
            }
            return this.query;
        }

        public String toString() {
            return this.query.toString();
        }
    }

    public static class QueryAndFilter {
        public final QueryBuilder query;
        public final QueryBuilder filter;

        public QueryAndFilter(QueryBuilder query, QueryBuilder filter) {
            this.query = query;
            this.filter = filter;
        }
    }
}

